/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.DOMElementSerializer;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class DOMElementSerializerTest
extends BaseDOMTest {
    protected DOMElementSerializerTest() {
        super(DOMElementSerializer.class);
    }

    @Test
    public void noItemsCollection() {
        ArrayList items = new ArrayList();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DOMElementSerializer ser = new DOMElementSerializer();
        ser.serializeCollection(items, (OutputStream)output);
        Assert.assertEquals((int)output.toByteArray().length, (int)0);
    }

    @Test
    public void twoItemsCollection() throws Exception {
        DOMElementSerializer ser = new DOMElementSerializer();
        ArrayList<DOMElementItem> items = new ArrayList<DOMElementItem>();
        Element x1 = this.readXMLData("1.xml");
        DOMElementItem i1 = new DOMElementItem(x1);
        items.add(i1);
        Element x2 = this.readXMLData("2.xml");
        DOMElementItem i2 = new DOMElementItem(x2);
        items.add(i2);
        Assert.assertEquals((int)items.size(), (int)2);
        ByteArrayOutputStream o1 = new ByteArrayOutputStream();
        ser.serialize((Item)i1, (OutputStream)o1);
        ByteArrayOutputStream o2 = new ByteArrayOutputStream();
        ser.serializeCollection(items, (OutputStream)o2);
        Assert.assertEquals((byte[])o2.toByteArray(), (byte[])o1.toByteArray());
    }
}

