/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.util.ArrayList;
import net.shibboleth.metadata.BaseTest;
import net.shibboleth.metadata.dom.DOMFilesystemSourceStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DOMFilesystemSourceTest
extends BaseTest {
    public DOMFilesystemSourceTest() {
        super(DOMFilesystemSourceStage.class);
    }

    @Test
    public void testSuccessfulFileFetchAndParse() throws Exception {
        URL sourceUrl = this.getClasspathResource("in.xml").getURL();
        File sourceFile = new File(sourceUrl.toURI());
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DOMFilesystemSourceStage source = new DOMFilesystemSourceStage();
        source.setId("test");
        source.setParserPool((ParserPool)parserPool);
        source.setSource(sourceFile);
        source.initialize();
        ArrayList metadataCollection = new ArrayList();
        source.execute(metadataCollection);
        Assert.assertNotNull(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
    }

    @Test
    public void testSuccessfulDirectoryFetchAndParse() throws Exception {
        URL sourceUrl = this.getClasspathResource("dir").getURL();
        File sourceFile = new File(sourceUrl.toURI());
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DOMFilesystemSourceStage source = new DOMFilesystemSourceStage();
        source.setId("test");
        source.setParserPool((ParserPool)parserPool);
        source.setSource(sourceFile);
        source.initialize();
        ArrayList metadataCollection = new ArrayList();
        source.execute(metadataCollection);
        Assert.assertNotNull(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)6);
    }

    @Test
    public void testSuccessfulDirectoryFetchWithFilterAndParse() throws Exception {
        URL sourceUrl = this.getClasspathResource("dir").getURL();
        File sourceFile = new File(sourceUrl.toURI());
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DOMFilesystemSourceStage source = new DOMFilesystemSourceStage();
        source.setId("test");
        source.setParserPool((ParserPool)parserPool);
        source.setSource(sourceFile);
        source.setRecurseDirectories(true);
        source.setSourceFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith("2.xml");
            }
        });
        source.initialize();
        ArrayList metadataCollection = new ArrayList();
        source.execute(metadataCollection);
        Assert.assertNotNull(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)2);
    }

    @Test
    public void testSuccessfulFetchAndFailedParse() throws Exception {
        URL sourceUrl = this.getClasspathResource("lorem.txt").getURL();
        File sourceFile = new File(sourceUrl.toURI());
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DOMFilesystemSourceStage source = new DOMFilesystemSourceStage();
        source.setId("test");
        source.setParserPool((ParserPool)parserPool);
        source.setSource(sourceFile);
        source.initialize();
        try {
            ArrayList metadataCollection = new ArrayList();
            source.execute(metadataCollection);
            throw new ConstraintViolationException("Source did not fail when given a non-XML file");
        }
        catch (StageProcessingException stageProcessingException) {
            return;
        }
    }

    @Test
    public void testFailedFetch() throws Exception {
        File sourceFile = new File("nonExistant");
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        DOMFilesystemSourceStage source = new DOMFilesystemSourceStage();
        source.setId("test");
        source.setParserPool((ParserPool)parserPool);
        source.setSource(sourceFile);
        source.setNoSourceFilesAnError(true);
        try {
            source.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }
}

