/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.IOException;
import java.util.ArrayList;
import net.shibboleth.metadata.dom.DOMResourceSourceStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.mockito.Mockito;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DOMResourceSourceTest {
    BasicParserPool parserPool;

    @BeforeClass
    void initialize() throws Exception {
        this.parserPool = new BasicParserPool();
        this.parserPool.initialize();
    }

    @Test
    public void testSuccessfulFetchAndParse() throws Exception {
        UrlResource mdResource = new UrlResource("https://issues.shibboleth.net/jira/Shibboleth.sso/Metadata");
        DOMResourceSourceStage source = new DOMResourceSourceStage();
        source.setId("test");
        source.setDOMResource((Resource)mdResource);
        source.setParserPool((ParserPool)this.parserPool);
        source.initialize();
        ArrayList metadataCollection = new ArrayList();
        source.execute(metadataCollection);
        Assert.assertNotNull(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
    }

    @Test
    public void testSuccessfulFetchAndFailedParse() throws Exception {
        UrlResource mdResource = new UrlResource("http://www.google.com/intl/en/images/about_logo.gif");
        DOMResourceSourceStage source = new DOMResourceSourceStage();
        String stageIdentifier = "testStage";
        source.setId("testStage");
        source.setDOMResource((Resource)mdResource);
        source.setParserPool((ParserPool)this.parserPool);
        source.initialize();
        try {
            ArrayList metadataCollection = new ArrayList();
            source.execute(metadataCollection);
            throw new ConstraintViolationException("Invalid URL marked as parsed");
        }
        catch (StageProcessingException e) {
            String message = e.getMessage();
            Assert.assertTrue((boolean)message.contains("testStage"), (String)"message should contain stage identifier");
            Assert.assertNotNull((Object)e.getCause(), (String)"exception should have cause");
            Assert.assertTrue((boolean)message.contains(mdResource.getDescription()), (String)"message should contain resource description");
            return;
        }
    }

    @Test
    public void testFailedFetch() throws Exception {
        UrlResource mdResource = new UrlResource("http://kslkjf.com/lkjlk3.dlw");
        DOMResourceSourceStage source = new DOMResourceSourceStage();
        source.setId("test");
        source.setDOMResource((Resource)mdResource);
        source.setParserPool((ParserPool)this.parserPool);
        try {
            source.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void testMDA130() throws Exception {
        Resource mockResource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)mockResource.exists()).thenReturn((Object)true);
        Mockito.when((Object)mockResource.getInputStream()).thenThrow(new Throwable[]{new IOException()});
        DOMResourceSourceStage source = new DOMResourceSourceStage();
        source.setId("test");
        source.setDOMResource(mockResource);
        source.setParserPool((ParserPool)this.parserPool);
        source.initialize();
        ArrayList metadataCollection = new ArrayList();
        try {
            source.execute(metadataCollection);
            Assert.fail();
        }
        catch (StageProcessingException stageProcessingException) {
            // empty catch block
        }
        Assert.assertNotNull(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)0);
    }
}

