/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.ElementWhitespaceTrimmingStage;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementWhitespaceTrimmingStageTest
extends BaseDOMTest {
    public ElementWhitespaceTrimmingStageTest() {
        super(ElementWhitespaceTrimmingStage.class);
    }

    private ElementWhitespaceTrimmingStage makeStage() throws ComponentInitializationException {
        ElementWhitespaceTrimmingStage stage = new ElementWhitespaceTrimmingStage();
        stage.setId("test");
        return stage;
    }

    private DOMElementItem makeItem(String which) throws XMLParserException {
        Element doc = this.readXMLData(this.classRelativeResource(which));
        return new DOMElementItem(doc);
    }

    @Test
    public void simpleTest() throws Exception {
        DOMElementItem item = this.makeItem("1-in.xml");
        Element expected = this.readXMLData(this.classRelativeResource("1-out.xml"));
        ArrayList<DOMElementItem> items = new ArrayList<DOMElementItem>();
        items.add(item);
        HashSet<QName> names = new HashSet<QName>();
        names.add(new QName("urn:oasis:names:tc:SAML:metadata:ui", "DisplayName"));
        names.add(new QName("urn:oasis:names:tc:SAML:2.0:metadata", "NameIDFormat"));
        ElementWhitespaceTrimmingStage stage = this.makeStage();
        stage.setElementNames(names);
        stage.initialize();
        stage.execute(items);
        this.assertXMLIdentical(expected, (Node)item.unwrap());
    }

    @Test
    public void testSingleton() throws Exception {
        DOMElementItem item = this.makeItem("2-in.xml");
        Element expected = this.readXMLData(this.classRelativeResource("2-out.xml"));
        ArrayList<DOMElementItem> items = new ArrayList<DOMElementItem>();
        items.add(item);
        ElementWhitespaceTrimmingStage stage = this.makeStage();
        stage.setElementName(new QName("urn:oasis:names:tc:SAML:2.0:metadata", "NameIDFormat"));
        stage.initialize();
        stage.execute(items);
        this.assertXMLIdentical(expected, (Node)item.unwrap());
    }
}

