/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.NamespacesStrippingStage;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NamespacesStrippingStageTest
extends BaseDOMTest {
    public NamespacesStrippingStageTest() {
        super(NamespacesStrippingStage.class);
    }

    @Test
    public void simple() throws Exception {
        Element doc = this.readXMLData("1-in.xml");
        DOMElementItem item = new DOMElementItem(doc);
        ArrayList<DOMElementItem> items = new ArrayList<DOMElementItem>();
        items.add(item);
        NamespacesStrippingStage stage = new NamespacesStrippingStage();
        stage.setId("stripTest");
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add("urn:namespace:beta");
        stage.setNamespaces(namespaces);
        stage.initialize();
        stage.execute(items);
        Element out = this.readXMLData("1-out.xml");
        this.assertXMLIdentical(out, (Node)item.unwrap());
    }

    @Test
    public void blacklist() throws Exception {
        Element doc = this.readXMLData("2-in.xml");
        DOMElementItem item = new DOMElementItem(doc);
        ArrayList<DOMElementItem> items = new ArrayList<DOMElementItem>();
        items.add(item);
        NamespacesStrippingStage stage = new NamespacesStrippingStage();
        stage.setId("stripTest");
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add("urn:namespace:bravo");
        namespaces.add("urn:namespace:charlie");
        stage.setNamespaces(namespaces);
        stage.initialize();
        stage.execute(items);
        Element out = this.readXMLData("2-bl.xml");
        this.assertXMLIdentical(out, (Node)item.unwrap());
    }

    @Test
    public void whitelist() throws Exception {
        Element doc = this.readXMLData("2-in.xml");
        DOMElementItem item = new DOMElementItem(doc);
        ArrayList<DOMElementItem> items = new ArrayList<DOMElementItem>();
        items.add(item);
        NamespacesStrippingStage stage = new NamespacesStrippingStage();
        stage.setId("stripTest");
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add("urn:namespace:alfa");
        namespaces.add("urn:namespace:bravo");
        namespaces.add("urn:namespace:charlie");
        stage.setNamespaces(namespaces);
        stage.setWhitelisting(true);
        stage.initialize();
        stage.execute(items);
        Element out = this.readXMLData("2-wl.xml");
        this.assertXMLIdentical(out, (Node)item.unwrap());
    }
}

