/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.WhitespaceTrimmingVisitor;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WhitespaceTrimmingVisitorTest
extends BaseDOMTest {
    public WhitespaceTrimmingVisitorTest() {
        super(WhitespaceTrimmingVisitor.class);
    }

    private DOMElementItem makeItem() throws Exception {
        ParserPool parserPool = this.getParserPool();
        DocumentBuilder builder = parserPool.getBuilder();
        Document document = builder.newDocument();
        Element element = ElementSupport.constructElement((Document)document, (QName)SAMLMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        ElementSupport.setDocumentElement((Document)document, (Element)element);
        return new DOMElementItem(element);
    }

    @Test
    public void visitAttr() throws Exception {
        DOMElementItem item = this.makeItem();
        Document doc = ((Element)item.unwrap()).getOwnerDocument();
        Attr attr = doc.createAttribute("foo");
        attr.setTextContent("   trimmed   \n\n   \t   ");
        WhitespaceTrimmingVisitor av = new WhitespaceTrimmingVisitor();
        av.visitAttr(attr, (Item)item);
        Assert.assertEquals((String)attr.getTextContent(), (String)"trimmed");
    }

    @Test
    public void visitElement() throws Exception {
        DOMElementItem item = this.makeItem();
        Document doc = ((Element)item.unwrap()).getOwnerDocument();
        Element e = doc.createElement("foo");
        e.setTextContent("   trimmed   \n\n   \t   ");
        WhitespaceTrimmingVisitor ev = new WhitespaceTrimmingVisitor();
        ev.visitElement(e, (Item)item);
        Assert.assertEquals((String)e.getTextContent(), (String)"trimmed");
    }

    @Test
    public void visitNode() throws Exception {
        DOMElementItem item = this.makeItem();
        Document doc = ((Element)item.unwrap()).getOwnerDocument();
        Attr attr = doc.createAttribute("foo");
        attr.setTextContent("   trimmed   \n\n   \t   ");
        WhitespaceTrimmingVisitor nv = new WhitespaceTrimmingVisitor();
        nv.visitNode((Node)attr, (Item)item);
        Assert.assertEquals((String)attr.getTextContent(), (String)"trimmed");
    }
}

