/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.Collection;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.XMLSchemaValidationStage;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class XMLSchemaValidationStageTest
extends BaseDOMTest {
    public XMLSchemaValidationStageTest() {
        super(XMLSchemaValidationStage.class);
    }

    @Test
    public void testValidXml() throws Exception {
        XMLSchemaValidationStage stage = this.buildStage();
        Collection<Item<Element>> mdCol = this.buildMetdataCollection("valid.xml");
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Assert.assertFalse((boolean)mdCol.iterator().next().getItemMetadata().containsKey(ErrorStatus.class));
    }

    @Test
    public void testInvalidXml() throws Exception {
        XMLSchemaValidationStage stage = this.buildStage();
        Collection<Item<Element>> mdCol = this.buildMetdataCollection("invalid.xml");
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Assert.assertTrue((boolean)mdCol.iterator().next().getItemMetadata().containsKey(ErrorStatus.class));
    }

    protected XMLSchemaValidationStage buildStage() throws Exception {
        ArrayList<Resource> schemaResources = new ArrayList<Resource>();
        schemaResources.add(this.getClasspathResource("schema.xsd"));
        XMLSchemaValidationStage stage = new XMLSchemaValidationStage();
        stage.setId("test");
        stage.setSchemaResources(schemaResources);
        stage.initialize();
        return stage;
    }

    protected Collection<Item<Element>> buildMetdataCollection(String xmlPath) throws Exception {
        Element element = this.readXMLData(xmlPath);
        ArrayList<Item<Element>> mdCol = new ArrayList<Item<Element>>();
        mdCol.add((Item<Element>)new DOMElementItem(element));
        return mdCol;
    }
}

