/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import net.shibboleth.metadata.AssertSupport;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.XMLSignatureSigningStage;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.cryptacular.util.CertUtil;
import org.cryptacular.util.KeyPairUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSignatureSigningStageTest
extends BaseDOMTest {
    public XMLSignatureSigningStageTest() {
        super(XMLSignatureSigningStage.class);
    }

    @Test
    public void testSigning() throws Exception {
        Element testInput = this.readXMLData("input.xml");
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(new DOMElementItem(testInput));
        PrivateKey signingKey = KeyPairUtil.readPrivateKey((InputStream)XMLSignatureSigningStageTest.class.getResourceAsStream(this.classRelativeResource("signingKey.pem")));
        X509Certificate signingCert = CertUtil.readCertificate((InputStream)XMLSignatureSigningStageTest.class.getResourceAsStream(this.classRelativeResource("signingCert.pem")));
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.add(signingCert);
        XMLSignatureSigningStage stage = new XMLSignatureSigningStage();
        stage.setId("test");
        stage.setIncludeKeyValue(false);
        stage.setIncludeX509IssuerSerial(true);
        stage.setPrivateKey(signingKey);
        stage.setCertificates(certs);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XMLSignatureSigningStage.class, "test");
        Element expected = this.readXMLData("output.xml");
        this.assertXMLIdentical(expected, (Node)result.unwrap());
    }

    @Test
    public void testSetIdAttributeNamesNull() throws Exception {
        XMLSignatureSigningStage stage = new XMLSignatureSigningStage();
        stage.setId("test");
        try {
            stage.setIdAttributeNames(null);
            Assert.fail((String)"expected a constraint exception");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }
}

