/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.shibboleth.metadata.AssertSupport;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.XMLSignatureSigningStageTest;
import net.shibboleth.metadata.dom.XMLSignatureValidationStage;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.cryptacular.util.CertUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class XMLSignatureValidationStageTest
extends BaseDOMTest {
    private final Certificate signingCert = CertUtil.readCertificate((InputStream)XMLSignatureSigningStageTest.class.getResourceAsStream(this.classRelativeResource("signingCert.pem")));

    public XMLSignatureValidationStageTest() throws IOException {
        super(XMLSignatureValidationStage.class);
    }

    private DOMElementItem makeItem(String name) throws XMLParserException {
        Element input = this.readXMLData(name);
        return new DOMElementItem(input);
    }

    @Test
    public void testValidSignature() throws Exception {
        DOMElementItem item = this.makeItem("signed.xml");
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(item);
        XMLSignatureValidationStage stage = new XMLSignatureValidationStage();
        stage.setId("test");
        stage.setVerificationCertificate(this.signingCert);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XMLSignatureValidationStage.class, "test");
        List errors = result.getItemMetadata().get(ErrorStatus.class);
        Assert.assertEquals((int)errors.size(), (int)0);
        List warnings = result.getItemMetadata().get(WarningStatus.class);
        Assert.assertEquals((int)warnings.size(), (int)0);
    }

    @Test
    public void testInvalidSignature() throws Exception {
        DOMElementItem item = this.makeItem("badSignature.xml");
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(item);
        XMLSignatureValidationStage stage = new XMLSignatureValidationStage();
        stage.setId("test");
        stage.setVerificationCertificate(this.signingCert);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertTrue((boolean)item.getItemMetadata().containsKey(ErrorStatus.class));
    }

    @Test
    public void testRequiredSignature() throws Exception {
        DOMElementItem item = this.makeItem("entities2.xml");
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(item);
        XMLSignatureValidationStage stage = new XMLSignatureValidationStage();
        stage.setId("test");
        stage.setSignatureRequired(false);
        stage.setVerificationCertificate(this.signingCert);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XMLSignatureValidationStage.class, "test");
        DOMElementItem item2 = this.makeItem("entities2.xml");
        mdCol.clear();
        mdCol.add(item2);
        stage = new XMLSignatureValidationStage();
        stage.setId("test");
        stage.setSignatureRequired(true);
        stage.setVerificationCertificate(this.signingCert);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertTrue((boolean)item2.getItemMetadata().containsKey(ErrorStatus.class));
    }

    @Test
    public void testDigestBlacklist() throws Exception {
        DOMElementItem item = this.makeItem("signed.xml");
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(item);
        HashSet<String> blacklist = new HashSet<String>();
        blacklist.add("http://www.w3.org/2001/04/xmlenc#sha256");
        XMLSignatureValidationStage stage = new XMLSignatureValidationStage();
        stage.setId("test");
        stage.setVerificationCertificate(this.signingCert);
        stage.setBlacklistedDigests(blacklist);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.iterator().next();
        List errors = result.getItemMetadata().get(ErrorStatus.class);
        Assert.assertEquals((int)errors.size(), (int)1);
        String message = ((ErrorStatus)errors.get(0)).getStatusMessage();
        Assert.assertTrue((boolean)message.contains("blacklist"));
    }

    @Test
    public void testSignatureMethodBlacklist() throws Exception {
        DOMElementItem item = this.makeItem("signed.xml");
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(item);
        HashSet<String> blacklist = new HashSet<String>();
        blacklist.add("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        XMLSignatureValidationStage stage = new XMLSignatureValidationStage();
        stage.setId("test");
        stage.setVerificationCertificate(this.signingCert);
        stage.setBlacklistedSignatureMethods(blacklist);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.iterator().next();
        List errors = result.getItemMetadata().get(ErrorStatus.class);
        Assert.assertEquals((int)errors.size(), (int)1);
        String message = ((ErrorStatus)errors.get(0)).getStatusMessage();
        Assert.assertTrue((boolean)message.contains("blacklist"));
    }

    @Test
    public void testEmptyRefPermitted() throws Exception {
        DOMElementItem item = this.makeItem("emptyref.xml");
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(item);
        XMLSignatureValidationStage stage = new XMLSignatureValidationStage();
        stage.setId("test");
        stage.setVerificationCertificate(this.signingCert);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XMLSignatureValidationStage.class, "test");
        List errors = result.getItemMetadata().get(ErrorStatus.class);
        Assert.assertEquals((int)errors.size(), (int)0);
        List warnings = result.getItemMetadata().get(WarningStatus.class);
        Assert.assertEquals((int)warnings.size(), (int)0);
    }

    @Test
    public void testEmptyRefNotPermitted() throws Exception {
        DOMElementItem item = this.makeItem("emptyref.xml");
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(item);
        XMLSignatureValidationStage stage = new XMLSignatureValidationStage();
        stage.setId("test");
        stage.setVerificationCertificate(this.signingCert);
        stage.setPermittingEmptyReferences(false);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.iterator().next();
        List errors = result.getItemMetadata().get(ErrorStatus.class);
        Assert.assertEquals((int)errors.size(), (int)1);
        String message = ((ErrorStatus)errors.get(0)).getStatusMessage();
        Assert.assertTrue((boolean)message.contains("reference"));
    }
}

