/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.XPathFilteringStage;
import net.shibboleth.utilities.java.support.xml.SimpleNamespaceContext;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class XPathFilteringStageTest
extends BaseDOMTest {
    public XPathFilteringStageTest() {
        super(XPathFilteringStage.class);
    }

    @Test
    public void testExecute() throws Exception {
        HashMap<String, String> prefixMappings = new HashMap<String, String>();
        prefixMappings.put("ukfedlabel", "http://ukfederation.org.uk/2006/11/label");
        XPathFilteringStage strategy = new XPathFilteringStage();
        strategy.setXPathExpression("//ukfedlabel:DeletedEntity");
        strategy.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(prefixMappings));
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("1.xml")));
        metadataCollection.add(new DOMElementItem(this.readXMLData("2.xml")));
        metadataCollection.add(new DOMElementItem(this.readXMLData("3.xml")));
        Assert.assertEquals((int)metadataCollection.size(), (int)3);
        strategy.doExecute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
        Element element = (Element)((Item)metadataCollection.get(0)).unwrap();
        String id = element.getAttribute("id");
        Assert.assertEquals((String)id, (String)"entity2");
    }
}

