/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.shibboleth.metadata.AssertSupport;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.InfoStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.XSLTransformationStage;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLTtransformationStageTest
extends BaseDOMTest {
    public XSLTtransformationStageTest() {
        super(XSLTransformationStage.class);
    }

    private DOMElementItem makeInput() throws XMLParserException {
        Element testInput = this.readXMLData("input.xml");
        DOMElementItem metadata = new DOMElementItem(testInput);
        Assert.assertEquals((int)metadata.getItemMetadata().get(TestInfo.class).size(), (int)0);
        metadata.getItemMetadata().put((Object)new TestInfo());
        Assert.assertEquals((int)metadata.getItemMetadata().get(TestInfo.class).size(), (int)1);
        return metadata;
    }

    @Test
    public void testTransform1() throws Exception {
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(this.makeInput());
        Resource transform = this.getClasspathResource("transform1.xsl");
        XSLTransformationStage stage = new XSLTransformationStage();
        stage.setId("test");
        stage.setXSLResource(transform);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XSLTransformationStage.class, "test");
        Assert.assertEquals((int)result.getItemMetadata().get(TestInfo.class).size(), (int)1);
        Element expected = this.readXMLData("output.xml");
        this.assertXMLIdentical(expected, (Node)result.unwrap());
    }

    @Test
    public void testTransformParam() throws Exception {
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(this.makeInput());
        Resource transform = this.getClasspathResource("transform1.xsl");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fruit", "avocados");
        XSLTransformationStage stage = new XSLTransformationStage();
        stage.setId("test");
        stage.setXSLResource(transform);
        stage.setTransformParameters(params);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XSLTransformationStage.class, "test");
        Assert.assertEquals((int)result.getItemMetadata().get(TestInfo.class).size(), (int)1);
        Element expected = this.readXMLData("paramOutput.xml");
        this.assertXMLIdentical(expected, (Node)result.unwrap());
    }

    @Test
    public void testTransformListener() throws Exception {
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(this.makeInput());
        Resource transform = this.getClasspathResource("transformListener1.xsl");
        XSLTransformationStage stage = new XSLTransformationStage();
        stage.setId("test");
        stage.setXSLResource(transform);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        HashSet<String> names = new HashSet<String>();
        for (Item item : mdCol) {
            AssertSupport.assertValidComponentInfo(item, 1, XSLTransformationStage.class, "test");
            Assert.assertEquals((int)item.getItemMetadata().get(TestInfo.class).size(), (int)1);
            names.add(((Element)item.unwrap()).getNodeName());
            List infos = item.getItemMetadata().get(InfoStatus.class);
            Assert.assertEquals((int)infos.size(), (int)2);
            Assert.assertEquals((String)((InfoStatus)infos.get(0)).getStatusMessage(), (String)"second value");
            Assert.assertEquals((String)((InfoStatus)infos.get(1)).getStatusMessage(), (String)"second value second message");
            List warnings = item.getItemMetadata().get(WarningStatus.class);
            Assert.assertEquals((int)warnings.size(), (int)1);
            Assert.assertEquals((String)((WarningStatus)warnings.get(0)).getStatusMessage(), (String)"first value");
            List errors = item.getItemMetadata().get(ErrorStatus.class);
            Assert.assertEquals((int)errors.size(), (int)1);
            Assert.assertEquals((String)((ErrorStatus)errors.get(0)).getStatusMessage(), (String)"error value");
        }
        Assert.assertFalse((boolean)names.contains("firstValue"));
        Assert.assertTrue((boolean)names.contains("secondValue"));
    }

    @Test
    public void testInclude() throws Exception {
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(this.makeInput());
        Resource transform = this.getClasspathResource("includeMain.xsl");
        XSLTransformationStage stage = new XSLTransformationStage();
        stage.setId("test");
        stage.setXSLResource(transform);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XSLTransformationStage.class, "test");
        Assert.assertEquals((int)result.getItemMetadata().get(TestInfo.class).size(), (int)1);
        Element expected = this.readXMLData("output.xml");
        this.assertXMLIdentical(expected, (Node)result.unwrap());
    }

    @Test
    public void testOutsideDocumentElement() throws Exception {
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(this.makeInput());
        Resource transform = this.getClasspathResource("transform1.xsl");
        XSLTransformationStage stage = new XSLTransformationStage();
        stage.setId("test");
        stage.setXSLResource(transform);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XSLTransformationStage.class, "test");
        Assert.assertEquals((int)result.getItemMetadata().get(TestInfo.class).size(), (int)1);
        Element expected = this.readXMLData("output.xml");
        this.assertXMLIdentical(expected, (Node)result.unwrap());
        Node firstNode = ((Element)result.unwrap()).getOwnerDocument().getFirstChild();
        Assert.assertEquals((short)firstNode.getNodeType(), (short)8);
        Assert.assertEquals((String)firstNode.getNodeValue(), (String)"this is a comment");
    }

    @Test
    public void testURIResolver() throws Exception {
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(this.makeInput());
        Resource transform = this.getClasspathResource("includeMain.xsl");
        XSLTransformationStage stage = new XSLTransformationStage();
        stage.setId("test");
        stage.setXSLResource(transform);
        class MyResolver
        implements URIResolver {
            MyResolver() {
            }

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                if (href.equals("XSLTransformationStage-included.xsl")) {
                    Resource resource = XSLTtransformationStageTest.this.getClasspathResource("included2.xsl");
                    try {
                        return new StreamSource(resource.getInputStream());
                    }
                    catch (IOException e) {
                        throw new TransformerException("couldn't fetch second included file", e);
                    }
                }
                return null;
            }
        }
        stage.setURIResolver((URIResolver)new MyResolver());
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.iterator().next();
        AssertSupport.assertValidComponentInfo(result, 1, XSLTransformationStage.class, "test");
        Assert.assertEquals((int)result.getItemMetadata().get(TestInfo.class).size(), (int)1);
        Element expected = this.readXMLData("output2.xml");
        this.assertXMLIdentical(expected, (Node)result.unwrap());
    }

    private static class TestInfo
    implements ItemMetadata {
        private static final long serialVersionUID = -4133926323393787487L;

        private TestInfo() {
        }
    }
}

