/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.AssertSupport;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.InfoStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.XSLValidationStage;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLValidationStageTest
extends BaseDOMTest {
    public XSLValidationStageTest() {
        super(XSLValidationStage.class);
    }

    private DOMElementItem makeInput() throws XMLParserException {
        Element testInput = this.readXMLData("input.xml");
        DOMElementItem metadata = new DOMElementItem(testInput);
        Assert.assertEquals((int)metadata.getItemMetadata().get(TestInfo.class).size(), (int)0);
        metadata.getItemMetadata().put((Object)new TestInfo());
        Assert.assertEquals((int)metadata.getItemMetadata().get(TestInfo.class).size(), (int)1);
        return metadata;
    }

    @Test
    public void testValidation() throws Exception {
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(this.makeInput());
        Resource transform = this.getClasspathResource("validator.xsl");
        XSLValidationStage stage = new XSLValidationStage();
        stage.setId("test");
        stage.setXSLResource(transform);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.get(0);
        Element expected = this.readXMLData("input.xml");
        this.assertXMLIdentical(expected, (Node)result.unwrap());
        AssertSupport.assertValidComponentInfo(result, 1, XSLValidationStage.class, "test");
        Assert.assertEquals((int)result.getItemMetadata().get(TestInfo.class).size(), (int)1);
        List infos = result.getItemMetadata().get(InfoStatus.class);
        Assert.assertEquals((int)infos.size(), (int)2);
        Assert.assertEquals((String)((InfoStatus)infos.get(0)).getStatusMessage(), (String)"second value");
        Assert.assertEquals((String)((InfoStatus)infos.get(1)).getStatusMessage(), (String)"second value second message");
        List warnings = result.getItemMetadata().get(WarningStatus.class);
        Assert.assertEquals((int)warnings.size(), (int)1);
        Assert.assertEquals((String)((WarningStatus)warnings.get(0)).getStatusMessage(), (String)"first value");
        List errors = result.getItemMetadata().get(ErrorStatus.class);
        Assert.assertEquals((int)errors.size(), (int)1);
        Assert.assertEquals((String)((ErrorStatus)errors.get(0)).getStatusMessage(), (String)"error value");
    }

    @Test
    public void testMDA45() throws Exception {
        ArrayList<DOMElementItem> mdCol = new ArrayList<DOMElementItem>();
        mdCol.add(this.makeInput());
        Resource transform = this.getClasspathResource("mda45.xsl");
        XSLValidationStage stage = new XSLValidationStage();
        stage.setId("test");
        stage.setXSLResource(transform);
        stage.initialize();
        stage.execute(mdCol);
        Assert.assertEquals((int)mdCol.size(), (int)1);
        Item result = (Item)mdCol.get(0);
        List infos = result.getItemMetadata().get(InfoStatus.class);
        Assert.assertEquals((int)infos.size(), (int)1);
        Assert.assertEquals((String)((InfoStatus)infos.get(0)).getStatusMessage(), (String)"values");
    }

    private static class TestInfo
    implements ItemMetadata {
        private static final long serialVersionUID = -4133926323393787487L;

        private TestInfo() {
        }
    }
}

