/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.ds;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.ds.X509ValidationStage;
import net.shibboleth.metadata.validate.x509.X509RSAKeyLengthValidator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class X509ValidationStageTest
extends BaseDOMTest {
    public X509ValidationStageTest() throws Exception {
        super(X509ValidationStage.class);
    }

    private X509ValidationStage makeStage() throws ComponentInitializationException {
        X509ValidationStage stage = new X509ValidationStage();
        stage.setId("test");
        return stage;
    }

    private DOMElementItem makeItem(String which) throws XMLParserException {
        Element doc = this.readXMLData(this.classRelativeResource(which));
        return new DOMElementItem(doc);
    }

    private void errorsAndWarnings(Item<Element> item, int expectedErrors, int expectedWarnings) {
        List errors = item.getItemMetadata().get(ErrorStatus.class);
        Assert.assertEquals((int)errors.size(), (int)expectedErrors);
        List warnings = item.getItemMetadata().get(WarningStatus.class);
        Assert.assertEquals((int)warnings.size(), (int)expectedWarnings);
    }

    @Test
    public void testNothing() throws Exception {
        DOMElementItem item = this.makeItem("in.xml");
        ArrayList<DOMElementItem> items = new ArrayList<DOMElementItem>();
        items.add(item);
        X509ValidationStage stage = this.makeStage();
        stage.initialize();
        stage.execute(items);
        this.errorsAndWarnings((Item<Element>)item, 0, 0);
    }

    @Test
    public void testError() throws Exception {
        DOMElementItem item = this.makeItem("in.xml");
        ArrayList<DOMElementItem> items = new ArrayList<DOMElementItem>();
        items.add(item);
        X509RSAKeyLengthValidator val = new X509RSAKeyLengthValidator();
        val.setErrorBoundary(2049);
        ArrayList<X509RSAKeyLengthValidator> vals = new ArrayList<X509RSAKeyLengthValidator>();
        vals.add(val);
        X509ValidationStage stage = this.makeStage();
        stage.setValidators(vals);
        stage.initialize();
        stage.execute(items);
        this.errorsAndWarnings((Item<Element>)item, 1, 0);
    }

    @Test
    public void testWarning() throws Exception {
        DOMElementItem item = this.makeItem("in.xml");
        ArrayList<DOMElementItem> items = new ArrayList<DOMElementItem>();
        items.add(item);
        X509RSAKeyLengthValidator val = new X509RSAKeyLengthValidator();
        val.setWarningBoundary(2049);
        val.setErrorBoundary(2048);
        ArrayList<X509RSAKeyLengthValidator> vals = new ArrayList<X509RSAKeyLengthValidator>();
        vals.add(val);
        X509ValidationStage stage = this.makeStage();
        stage.setValidators(vals);
        stage.initialize();
        stage.execute(items);
        this.errorsAndWarnings((Item<Element>)item, 0, 1);
    }
}

