/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.ContactPersonFilterStage;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContactPersonFilterStageTest
extends BaseDOMTest {
    private final QName contactPersonQname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "ContactPerson");
    private Element entitiesDescriptor;

    public ContactPersonFilterStageTest() {
        super(ContactPersonFilterStage.class);
    }

    @BeforeClass
    public void setup() throws Exception {
        this.entitiesDescriptor = this.readXMLData("entities.xml");
    }

    @Test
    public void testDesignatedTypes() throws ComponentInitializationException {
        ContactPersonFilterStage stage = new ContactPersonFilterStage();
        stage.setId("foo");
        Assert.assertEquals((int)stage.getDesignateTypes().size(), (int)5);
        Assert.assertTrue((boolean)stage.getDesignateTypes().contains("administrative"));
        Assert.assertTrue((boolean)stage.getDesignateTypes().contains("billing"));
        Assert.assertTrue((boolean)stage.getDesignateTypes().contains("other"));
        Assert.assertTrue((boolean)stage.getDesignateTypes().contains("support"));
        Assert.assertTrue((boolean)stage.getDesignateTypes().contains("technical"));
        stage.setDesignatedTypes((Collection)Sets.newHashSet((Object[])new String[]{"administrative", null, "technical", "", "foo", "other"}));
        Assert.assertEquals((int)stage.getDesignateTypes().size(), (int)3);
        Assert.assertTrue((boolean)stage.getDesignateTypes().contains("administrative"));
        Assert.assertTrue((boolean)stage.getDesignateTypes().contains("other"));
        Assert.assertTrue((boolean)stage.getDesignateTypes().contains("technical"));
        stage.setDesignatedTypes(Collections.emptyList());
        Assert.assertEquals((int)stage.getDesignateTypes().size(), (int)0);
        stage.setDesignatedTypes(null);
        Assert.assertEquals((int)stage.getDesignateTypes().size(), (int)0);
        stage.initialize();
        try {
            stage.setDesignatedTypes((Collection)Sets.newHashSet((Object[])new String[]{"administrative"}));
            Assert.fail();
        }
        catch (UnmodifiableComponentException e) {
            Assert.assertEquals((int)stage.getDesignateTypes().size(), (int)0);
        }
        stage = new ContactPersonFilterStage();
        stage.destroy();
        try {
            stage.setDesignatedTypes((Collection)Sets.newHashSet((Object[])new String[]{"administrative"}));
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
        stage = new ContactPersonFilterStage();
        try {
            stage.getDesignateTypes().add("foo");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testWhitelistingTypes() throws ComponentInitializationException {
        ContactPersonFilterStage stage = new ContactPersonFilterStage();
        stage.setId("foo");
        Assert.assertTrue((boolean)stage.isWhitelistingTypes());
        stage.setWhitelistingTypes(false);
        Assert.assertFalse((boolean)stage.isWhitelistingTypes());
        stage.initialize();
        try {
            stage.setWhitelistingTypes(true);
            Assert.fail();
        }
        catch (UnmodifiableComponentException e) {
            Assert.assertFalse((boolean)stage.isWhitelistingTypes());
        }
        stage = new ContactPersonFilterStage();
        stage.destroy();
        try {
            stage.setWhitelistingTypes(true);
            Assert.fail();
        }
        catch (DestroyedComponentException destroyedComponentException) {
            // empty catch block
        }
    }

    @Test
    public void testWhitelistContactPersons() throws Exception {
        ContactPersonFilterStage stage = new ContactPersonFilterStage();
        stage.setId("foo");
        stage.initialize();
        ArrayList<DOMElementItem> itemCollection = new ArrayList<DOMElementItem>();
        itemCollection.add(new DOMElementItem(this.entitiesDescriptor));
        stage.execute(itemCollection);
        Element filteredEntitiesDescriptor = (Element)((Item)itemCollection.get(0)).unwrap();
        List entityDescriptors = ElementSupport.getChildElements((Node)filteredEntitiesDescriptor);
        Element idpDescriptor = (Element)entityDescriptors.get(0);
        List contactPersons = ElementSupport.getChildElements((Node)idpDescriptor, (QName)this.contactPersonQname);
        Assert.assertEquals((int)contactPersons.size(), (int)1);
        Element issuesDescriptor = (Element)entityDescriptors.get(1);
        contactPersons = ElementSupport.getChildElements((Node)issuesDescriptor, (QName)this.contactPersonQname);
        Assert.assertEquals((int)contactPersons.size(), (int)5);
        Element wikiDescriptor = (Element)entityDescriptors.get(2);
        contactPersons = ElementSupport.getChildElements((Node)wikiDescriptor, (QName)this.contactPersonQname);
        Assert.assertEquals((int)contactPersons.size(), (int)0);
    }

    @Test
    public void testBlacklistContactPersons() throws Exception {
        ContactPersonFilterStage stage = new ContactPersonFilterStage();
        stage.setId("foo");
        stage.setDesignatedTypes((Collection)Sets.newHashSet((Object[])new String[]{"administrative", "other"}));
        stage.setWhitelistingTypes(false);
        stage.initialize();
        ArrayList<DOMElementItem> itemCollection = new ArrayList<DOMElementItem>();
        itemCollection.add(new DOMElementItem(this.entitiesDescriptor));
        stage.execute(itemCollection);
        Element filteredEntitiesDescriptor = (Element)((Item)itemCollection.get(0)).unwrap();
        List entityDescriptors = ElementSupport.getChildElements((Node)filteredEntitiesDescriptor);
        Element idpDescriptor = (Element)entityDescriptors.get(0);
        List contactPersons = ElementSupport.getChildElements((Node)idpDescriptor, (QName)this.contactPersonQname);
        Assert.assertEquals((int)contactPersons.size(), (int)1);
        Element issuesDescriptor = (Element)entityDescriptors.get(1);
        contactPersons = ElementSupport.getChildElements((Node)issuesDescriptor, (QName)this.contactPersonQname);
        Assert.assertEquals((int)contactPersons.size(), (int)3);
        Element wikiDescriptor = (Element)entityDescriptors.get(2);
        contactPersons = ElementSupport.getChildElements((Node)wikiDescriptor, (QName)this.contactPersonQname);
        Assert.assertEquals((int)contactPersons.size(), (int)0);
    }
}

