/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.EntitiesDescriptorAssemblerStage;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class EntitiesDescriptorAssemblerStageTest
extends BaseDOMTest {
    public EntitiesDescriptorAssemblerStageTest() {
        super(EntitiesDescriptorAssemblerStage.class);
    }

    @Test
    public void testAssemblingWithoutName() throws Exception {
        Collection<Item<Element>> metadataCollection = this.buildMetadataCollection();
        EntitiesDescriptorAssemblerStage stage = new EntitiesDescriptorAssemblerStage();
        stage.setId("foo");
        stage.initialize();
        stage.execute(metadataCollection);
        Element result = (Element)metadataCollection.iterator().next().unwrap();
        this.assertXMLIdentical(this.readXMLData("entities.xml"), result);
    }

    @Test
    public void testAssemblingWithName() throws Exception {
        Collection<Item<Element>> metadataCollection = this.buildMetadataCollection();
        EntitiesDescriptorAssemblerStage stage = new EntitiesDescriptorAssemblerStage();
        stage.setId("foo");
        stage.setDescriptorName("nameValue");
        stage.initialize();
        stage.execute(metadataCollection);
        Element result = (Element)metadataCollection.iterator().next().unwrap();
        this.assertXMLIdentical(this.readXMLData("name.xml"), result);
    }

    @Test
    public void testAssemblingWithOrdering() throws Exception {
        Collection<Item<Element>> metadataCollection = this.buildMetadataCollection();
        EntitiesDescriptorAssemblerStage stage = new EntitiesDescriptorAssemblerStage();
        stage.setId("foo");
        class ReverseOrder
        implements EntitiesDescriptorAssemblerStage.ItemOrderingStrategy {
            ReverseOrder() {
            }

            public List<Item<Element>> order(Collection<Item<Element>> items) {
                ArrayList<Item<Element>> result = new ArrayList<Item<Element>>(items);
                Collections.reverse(result);
                return result;
            }
        }
        stage.setItemOrderingStrategy((EntitiesDescriptorAssemblerStage.ItemOrderingStrategy)new ReverseOrder());
        stage.initialize();
        stage.execute(metadataCollection);
        Element result = (Element)metadataCollection.iterator().next().unwrap();
        this.assertXMLIdentical(this.readXMLData("reversed.xml"), result);
    }

    @Test
    public void testMda87() throws Exception {
        Collection<Item<Element>> metadataCollection = this.buildMetadataCollection();
        EntitiesDescriptorAssemblerStage stage = new EntitiesDescriptorAssemblerStage();
        stage.setId("foo");
        stage.initialize();
        stage.execute(metadataCollection);
        Element result = (Element)metadataCollection.iterator().next().unwrap();
        Assert.assertEquals((String)result.getLocalName(), (String)"EntitiesDescriptor");
        Assert.assertEquals((String)result.getPrefix(), (String)"md");
        Assert.assertEquals((String)result.getNamespaceURI(), (String)"urn:oasis:names:tc:SAML:2.0:metadata");
        String nsattr = result.getAttributeNS("http://www.w3.org/2000/xmlns/", "md");
        Assert.assertEquals((String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)nsattr);
    }

    protected Collection<Item<Element>> buildMetadataCollection() throws Exception {
        ArrayList<Item<Element>> metadataCollection = new ArrayList<Item<Element>>();
        Element descriptor = this.readXMLData("entity1.xml");
        metadataCollection.add((Item<Element>)new DOMElementItem(descriptor));
        descriptor = this.readXMLData("entity2.xml");
        metadataCollection.add((Item<Element>)new DOMElementItem(descriptor));
        Element fooElement = this.getParserPool().newDocument().createElement("foo");
        metadataCollection.add((Item<Element>)new DOMElementItem(fooElement));
        return metadataCollection;
    }
}

