/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.EntityDescriptorItemIdPopulationStage;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class EntityDescriptorItemIdPopulationStageTest
extends BaseDOMTest {
    public EntityDescriptorItemIdPopulationStageTest() {
        super(EntityDescriptorItemIdPopulationStage.class);
    }

    @Test
    public void testEmptyCollection() throws Exception {
        ArrayList metadataCollection = new ArrayList();
        EntityDescriptorItemIdPopulationStage stage = new EntityDescriptorItemIdPopulationStage();
        stage.setId("foo");
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertTrue((boolean)metadataCollection.isEmpty());
    }

    @Test
    public void testDifferentElement() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("different.xml")));
        EntityDescriptorItemIdPopulationStage stage = new EntityDescriptorItemIdPopulationStage();
        stage.setId("foo");
        stage.initialize();
        List itemIds = ((DOMElementItem)metadataCollection.get(0)).getItemMetadata().get(ItemId.class);
        Assert.assertEquals((int)itemIds.size(), (int)0);
    }

    @Test
    public void testSingleRecord() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("1.xml")));
        EntityDescriptorItemIdPopulationStage stage = new EntityDescriptorItemIdPopulationStage();
        stage.setId("foo");
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
        Item item = (Item)metadataCollection.get(0);
        Element entityDescriptor = (Element)item.unwrap();
        List itemIds = item.getItemMetadata().get(ItemId.class);
        Assert.assertEquals((int)itemIds.size(), (int)1);
        ItemId itemId = (ItemId)itemIds.get(0);
        Assert.assertEquals((String)itemId.getId(), (String)entityDescriptor.getAttributeNS(null, "entityID"));
    }

    @Test
    public void testMultipleRecords() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("1.xml")));
        metadataCollection.add(new DOMElementItem(this.readXMLData("2.xml")));
        EntityDescriptorItemIdPopulationStage stage = new EntityDescriptorItemIdPopulationStage();
        stage.setId("foo");
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)2);
        for (Item item : metadataCollection) {
            Element entityDescriptor = (Element)item.unwrap();
            List itemIds = item.getItemMetadata().get(ItemId.class);
            Assert.assertEquals((int)itemIds.size(), (int)1);
            ItemId itemId = (ItemId)itemIds.get(0);
            Assert.assertEquals((String)itemId.getId(), (String)entityDescriptor.getAttributeNS(null, "entityID"));
        }
    }
}

