/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.EntityFilterStage;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EntityFilterStageTest
extends BaseDOMTest {
    public EntityFilterStageTest() {
        super(EntityFilterStage.class);
    }

    @Test
    public void testEntityWhitelist() throws Exception {
        EntityFilterStage stage = new EntityFilterStage();
        stage.setId("test");
        stage.setDesignatedEntities(Collections.singletonList("https://idp.shibboleth.net/idp/shibboleth"));
        stage.setWhitelistingEntities(true);
        stage.initialize();
        Collection<Item<Element>> metadataCollection = this.buildMetadataCollection();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
    }

    @Test
    public void testEntityBlacklist() throws Exception {
        EntityFilterStage stage = new EntityFilterStage();
        stage.setId("test");
        stage.setDesignatedEntities(Collections.singletonList("https://idp.shibboleth.net/idp/shibboleth"));
        stage.setWhitelistingEntities(false);
        stage.initialize();
        Collection<Item<Element>> metadataCollection = this.buildMetadataCollection();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)2);
    }

    @Test
    public void testEntitiesDescriptorFiltering() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("in.xml")));
        EntityFilterStage stage = new EntityFilterStage();
        stage.setId("test");
        stage.setDesignatedEntities(Collections.singletonList("https://idp.shibboleth.net/idp/shibboleth"));
        stage.setWhitelistingEntities(false);
        stage.initialize();
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((Item)metadataCollection.iterator().next()).unwrap();
        Assert.assertEquals((int)ElementSupport.getChildElements((Node)entitiesDescriptor).size(), (int)2);
    }

    @Test
    public void testRemoveEntitylessEntitiesDescriptor() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("in.xml")));
        EntityFilterStage stage = new EntityFilterStage();
        stage.setId("test");
        stage.setDesignatedEntities(Arrays.asList("https://idp.shibboleth.net/idp/shibboleth", "https://issues.shibboleth.net/shibboleth", "https://wiki.shibboleth.net/shibboleth"));
        stage.setWhitelistingEntities(false);
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)0);
    }

    @Test
    public void testDontRemoveEntitylessEntitiesDescriptor() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("in.xml")));
        EntityFilterStage stage = new EntityFilterStage();
        stage.setId("test");
        stage.setRemovingEntitylessEntitiesDescriptor(false);
        stage.setDesignatedEntities(Arrays.asList("https://idp.shibboleth.net/idp/shibboleth", "https://issues.shibboleth.net/shibboleth", "https://wiki.shibboleth.net/shibboleth"));
        stage.setWhitelistingEntities(false);
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
    }

    private Collection<Item<Element>> buildMetadataCollection() throws Exception {
        ArrayList<Item<Element>> metadataCollection = new ArrayList<Item<Element>>();
        List descriptors = ElementSupport.getChildElements((Node)this.readXMLData("in.xml"));
        for (Element descriptor : descriptors) {
            metadataCollection.add((Item<Element>)new DOMElementItem(descriptor));
        }
        return metadataCollection;
    }
}

