/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.GenerateIdStage;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenerateIdStageTest {
    @Test
    public void mda90() throws Exception {
        GenerateIdStage stage = new GenerateIdStage();
        stage.setId("test");
        stage.initialize();
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        Document doc = parserPool.newDocument();
        QName qname = SAMLMetadataSupport.ENTITY_DESCRIPTOR_NAME;
        Element element = ElementSupport.constructElement((Document)doc, (QName)qname);
        Assert.assertEquals((String)element.getLocalName(), (String)qname.getLocalPart());
        doc.appendChild(element);
        DOMElementItem item = new DOMElementItem(doc);
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(item);
        Pattern ncNamePattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_\\-\\.]+$");
        int howMany = 1000;
        HashSet<String> values = new HashSet<String>(1000);
        for (int iteration = 1; iteration <= 1000; ++iteration) {
            stage.execute(metadataCollection);
            Element el = (Element)item.unwrap();
            Assert.assertEquals((String)el.getLocalName(), (String)qname.getLocalPart());
            Assert.assertTrue((boolean)el.hasAttribute("ID"));
            String value = el.getAttribute("ID");
            Assert.assertNotNull((Object)value);
            if (values.contains(value)) {
                Assert.fail((String)("duplicate value '" + value + "' on iteration " + iteration));
            }
            values.add(value);
            Matcher match = ncNamePattern.matcher(value);
            if (match.matches()) continue;
            Assert.fail((String)("value '" + value + "' is not a valid NCName on iteration " + iteration));
        }
        Assert.assertEquals((int)values.size(), (int)1000);
    }
}

