/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.PullUpCacheDurationStage;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PullUpCacheDurationStageTest
extends BaseDOMTest {
    public PullUpCacheDurationStageTest() {
        super(PullUpCacheDurationStage.class);
    }

    @Test
    public void testPullCacheDuration() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("in.xml")));
        PullUpCacheDurationStage stage = new PullUpCacheDurationStage();
        stage.setId("test");
        stage.initialize();
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((Item)metadataCollection.get(0)).unwrap();
        Attr durationAttr = AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        Assert.assertNotNull((Object)durationAttr);
        long duration = AttributeSupport.getDurationAttributeValueAsLong((Attr)durationAttr);
        Assert.assertEquals((long)duration, (long)3600000L);
        List entityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SAMLMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        Assert.assertEquals((int)entityDescriptors.size(), (int)3);
        for (Element entityDescriptor : entityDescriptors) {
            Assert.assertFalse((boolean)AttributeSupport.hasAttribute((Element)entityDescriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME));
        }
    }

    @Test
    public void testMinCacheDuration() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("in.xml")));
        PullUpCacheDurationStage stage = new PullUpCacheDurationStage();
        stage.setId("test");
        stage.setMinimumCacheDuration(0x6DDD00L);
        stage.initialize();
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((Item)metadataCollection.get(0)).unwrap();
        Attr durationAttr = AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        Assert.assertNotNull((Object)durationAttr);
        long duration = AttributeSupport.getDurationAttributeValueAsLong((Attr)durationAttr);
        Assert.assertEquals((long)duration, (long)0x6DDD00L);
    }

    @Test
    public void testMaxCacheDuration() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("in.xml")));
        PullUpCacheDurationStage stage = new PullUpCacheDurationStage();
        stage.setId("test");
        stage.setMaximumCacheDuration(1800000L);
        stage.initialize();
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((Item)metadataCollection.get(0)).unwrap();
        Attr durationAttr = AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        Assert.assertNotNull((Object)durationAttr);
        long duration = AttributeSupport.getDurationAttributeValueAsLong((Attr)durationAttr);
        Assert.assertEquals((long)duration, (long)1800000L);
    }
}

