/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.PullUpValidUntilStage;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PullUpValidUntilStageTest
extends BaseDOMTest {
    public PullUpValidUntilStageTest() {
        super(PullUpValidUntilStage.class);
    }

    @Test
    public void testPullCacheDuration() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("in.xml")));
        PullUpValidUntilStage stage = new PullUpValidUntilStage();
        stage.setId("test");
        stage.initialize();
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((Item)metadataCollection.get(0)).unwrap();
        Attr validUntilAttr = AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME);
        Assert.assertNotNull((Object)validUntilAttr);
        long validUntil = AttributeSupport.getDateTimeAttributeAsLong((Attr)validUntilAttr);
        Assert.assertEquals((long)validUntil, (long)2429913600000L);
        List entityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor, (QName)SAMLMetadataSupport.ENTITY_DESCRIPTOR_NAME);
        Assert.assertEquals((int)entityDescriptors.size(), (int)3);
        for (Element entityDescriptor : entityDescriptors) {
            Assert.assertFalse((boolean)AttributeSupport.hasAttribute((Element)entityDescriptor, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME));
        }
    }

    @Test
    public void testMinCacheDuration() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("in.xml")));
        long hundredYears = 3153600000000L;
        PullUpValidUntilStage stage = new PullUpValidUntilStage();
        stage.setId("test");
        stage.setMinimumValidityDuration(hundredYears);
        stage.initialize();
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((Item)metadataCollection.get(0)).unwrap();
        Attr validUntilAttr = AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME);
        Assert.assertNotNull((Object)validUntilAttr);
        long validUntil = AttributeSupport.getDateTimeAttributeAsLong((Attr)validUntilAttr);
        Assert.assertTrue((validUntil > System.currentTimeMillis() + hundredYears - 60000L ? 1 : 0) != 0);
    }

    @Test
    public void testMaxCacheDuration() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("in.xml")));
        long twoYears = 63072000000L;
        long twoYearsFromNow = twoYears + System.currentTimeMillis();
        PullUpValidUntilStage stage = new PullUpValidUntilStage();
        stage.setId("test");
        stage.setMaximumValidityDuration(twoYears);
        stage.initialize();
        stage.execute(metadataCollection);
        Element entitiesDescriptor = (Element)((Item)metadataCollection.get(0)).unwrap();
        Attr validUntilAttr = AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME);
        Assert.assertNotNull((Object)validUntilAttr);
        long validUntil = AttributeSupport.getDateTimeAttributeAsLong((Attr)validUntilAttr);
        long delta = 10000L;
        Assert.assertTrue((validUntil < twoYearsFromNow + delta ? 1 : 0) != 0);
        Assert.assertTrue((validUntil > twoYearsFromNow - delta ? 1 : 0) != 0);
    }
}

