/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.RemoveOrganizationStage;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RemoveOrganizationStageTest
extends BaseDOMTest {
    public RemoveOrganizationStageTest() {
        super(RemoveOrganizationStage.class);
    }

    @Test
    public void testRemoveOrganization() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        List descriptors = ElementSupport.getChildElements((Node)this.readXMLData("in.xml"));
        for (Element element : descriptors) {
            metadataCollection.add(new DOMElementItem(element));
        }
        for (Item item : metadataCollection) {
            Assert.assertFalse((boolean)ElementSupport.getChildElementsByTagNameNS((Node)((Node)item.unwrap()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Organization").isEmpty());
        }
        RemoveOrganizationStage stage = new RemoveOrganizationStage();
        stage.setId("test");
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)3);
        for (Item item : metadataCollection) {
            Assert.assertTrue((boolean)ElementSupport.getChildElementsByTagNameNS((Node)((Node)item.unwrap()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Organization").isEmpty());
        }
    }

    @Test
    public void testRemoveOrganizationFromNestedElements() throws Exception {
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(this.readXMLData("in.xml")));
        Element entitiesDescriptor = (Element)((Item)metadataCollection.get(0)).unwrap();
        List entityDescriptors = ElementSupport.getChildElements((Node)entitiesDescriptor);
        for (Element entityDescriptor : entityDescriptors) {
            Assert.assertFalse((boolean)ElementSupport.getChildElementsByTagNameNS((Node)entityDescriptor, (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Organization").isEmpty());
        }
        RemoveOrganizationStage stage = new RemoveOrganizationStage();
        stage.setId("test");
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)1);
        for (Element entityDescriptor : entityDescriptors) {
            Assert.assertTrue((boolean)ElementSupport.getChildElementsByTagNameNS((Node)entityDescriptor, (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Organization").isEmpty());
        }
    }
}

