/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.dom.saml.SetCacheDurationStage;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetCacheDurationStageTest
extends BaseDOMTest {
    public SetCacheDurationStageTest() {
        super(SetCacheDurationStage.class);
    }

    private long fetchDuration(Element descriptor) throws DatatypeConfigurationException {
        Date baseDate = new Date(0L);
        DatatypeFactory dtf = DatatypeFactory.newInstance();
        Attr cacheDurationAttr = AttributeSupport.getAttribute((Element)descriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        Assert.assertNotNull((Object)cacheDurationAttr);
        return dtf.newDuration(cacheDurationAttr.getValue()).getTimeInMillis(baseDate);
    }

    @Test
    public void testWithoutExistingCacheDuration() throws Exception {
        Element entitiesDescriptor = this.readXMLData("in.xml");
        DOMElementItem item = new DOMElementItem(entitiesDescriptor);
        Assert.assertTrue((AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME) == null ? 1 : 0) != 0);
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(item);
        long duration = 123456L;
        SetCacheDurationStage stage = new SetCacheDurationStage();
        stage.setId("test");
        stage.setCacheDuration(duration);
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((long)this.fetchDuration((Element)item.unwrap()), (long)duration);
    }

    @Test
    public void testWithExistingCacheDuration() throws Exception {
        Element entitiesDescriptor = this.readXMLData("in.xml");
        DOMElementItem item = new DOMElementItem(entitiesDescriptor);
        long originalDuration = 987654L;
        AttributeSupport.appendDurationAttribute((Element)entitiesDescriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME, (long)987654L);
        Assert.assertTrue((AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME) != null ? 1 : 0) != 0);
        Assert.assertEquals((long)this.fetchDuration(entitiesDescriptor), (long)987654L);
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(item);
        long duration = 123456L;
        SetCacheDurationStage stage = new SetCacheDurationStage();
        stage.setId("test");
        stage.setCacheDuration(duration);
        stage.initialize();
        stage.execute(metadataCollection);
        Assert.assertEquals((long)this.fetchDuration((Element)item.unwrap()), (long)duration);
    }

    @Test
    public void testWithNonDescriptorMetadataElement() throws Exception {
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        Document newDoc = parserPool.newDocument();
        Element root = newDoc.createElementNS("http://example.org", "foo");
        ElementSupport.setDocumentElement((Document)newDoc, (Element)root);
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(root));
        long duration = 123456L;
        SetCacheDurationStage stage = new SetCacheDurationStage();
        stage.setId("test");
        stage.setCacheDuration(duration);
        stage.initialize();
        stage.execute(metadataCollection);
        Attr cacheDurationAttr = AttributeSupport.getAttribute((Element)root, (QName)SAMLMetadataSupport.CACHE_DURATION_ATTRIB_NAME);
        Assert.assertNull((Object)cacheDurationAttr);
    }

    @Test
    public void testNegativeDuration() {
        long duration = -987654L;
        SetCacheDurationStage stage = new SetCacheDurationStage();
        stage.setId("test");
        try {
            stage.setCacheDuration(duration);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }
}

