/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.dom.saml.SetValidUntilStage;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetValidUntilStageTest
extends BaseDOMTest {
    public SetValidUntilStageTest() {
        super(SetValidUntilStage.class);
    }

    @Test
    public void testWithoutExistingValidUntil() throws Exception {
        Element entitiesDescriptor = this.readXMLData("in.xml");
        entitiesDescriptor.removeAttributeNS(null, SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME.getLocalPart());
        Assert.assertTrue((AttributeSupport.getAttribute((Element)entitiesDescriptor, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME) == null ? 1 : 0) != 0);
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(entitiesDescriptor));
        long duration = 123456L;
        long now = System.currentTimeMillis();
        SetValidUntilStage stage = new SetValidUntilStage();
        stage.setId("test");
        stage.setValidityDuration(duration);
        stage.initialize();
        stage.execute(metadataCollection);
        Attr validUntilAttr = AttributeSupport.getAttribute((Element)((Element)((Item)metadataCollection.iterator().next()).unwrap()), (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME);
        Assert.assertNotNull((Object)validUntilAttr);
        long validUntil = AttributeSupport.getDateTimeAttributeAsLong((Attr)validUntilAttr);
        Assert.assertTrue((validUntil > now + duration - 100L ? 1 : 0) != 0);
        Assert.assertTrue((validUntil < now + duration + 100L ? 1 : 0) != 0);
    }

    @Test
    public void testWithExistingValidUntil() throws Exception {
        Element entitiesDescriptor = this.readXMLData("in.xml");
        Assert.assertTrue((boolean)AttributeSupport.hasAttribute((Element)entitiesDescriptor, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME));
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(entitiesDescriptor));
        long duration = 123456L;
        long now = System.currentTimeMillis();
        SetValidUntilStage stage = new SetValidUntilStage();
        stage.setId("test");
        stage.setValidityDuration(duration);
        stage.initialize();
        stage.execute(metadataCollection);
        Attr validUntilAttr = AttributeSupport.getAttribute((Element)((Element)((Item)metadataCollection.iterator().next()).unwrap()), (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME);
        Assert.assertNotNull((Object)validUntilAttr);
        long validUntil = AttributeSupport.getDateTimeAttributeAsLong((Attr)validUntilAttr);
        Assert.assertTrue((validUntil > now + duration - 100L ? 1 : 0) != 0);
        Assert.assertTrue((validUntil < now + duration + 100L ? 1 : 0) != 0);
    }

    @Test
    public void testWithNonDescriptorMetadataElement() throws Exception {
        BasicParserPool parserPool = new BasicParserPool();
        parserPool.initialize();
        Document newDoc = parserPool.newDocument();
        Element root = newDoc.createElementNS("http://example.org", "foo");
        ElementSupport.setDocumentElement((Document)newDoc, (Element)root);
        ArrayList<DOMElementItem> metadataCollection = new ArrayList<DOMElementItem>();
        metadataCollection.add(new DOMElementItem(root));
        long duration = 123456L;
        SetValidUntilStage stage = new SetValidUntilStage();
        stage.setId("test");
        stage.setValidityDuration(duration);
        stage.initialize();
        stage.execute(metadataCollection);
        Attr validUntilAttr = AttributeSupport.getAttribute((Element)root, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME);
        Assert.assertNull((Object)validUntilAttr);
    }

    @Test
    public void testNegativeDuration() {
        long duration = -987654L;
        SetValidUntilStage stage = new SetValidUntilStage();
        stage.setId("test");
        try {
            stage.setValidityDuration(duration);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }
}

