/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml;

import javax.xml.namespace.QName;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.dom.saml.ValidateValidUntilStage;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class ValidateValidUntilStageTest
extends BaseDOMTest {
    public ValidateValidUntilStageTest() {
        super(ValidateValidUntilStage.class);
    }

    @Test
    public void testOptionalCheck() throws Exception {
        ValidateValidUntilStage stage = new ValidateValidUntilStage();
        stage.setId("test");
        stage.setRequireValidUntil(false);
        stage.initialize();
        DOMElementItem item = this.buildDomElementItem(0L);
        stage.doExecute((Item)item);
        Assert.assertFalse((boolean)item.getItemMetadata().containsKey(ErrorStatus.class));
        stage = new ValidateValidUntilStage();
        stage.setId("test");
        stage.setRequireValidUntil(true);
        stage.initialize();
        item = this.buildDomElementItem(0L);
        stage.doExecute((Item)item);
        Assert.assertTrue((boolean)item.getItemMetadata().containsKey(ErrorStatus.class));
    }

    @Test
    public void testValidUntilRangeCheck() throws Exception {
        ValidateValidUntilStage stage = new ValidateValidUntilStage();
        stage.setId("test");
        stage.setRequireValidUntil(false);
        stage.initialize();
        DOMElementItem item = this.buildDomElementItem(10000L);
        stage.doExecute((Item)item);
        Assert.assertFalse((boolean)item.getItemMetadata().containsKey(ErrorStatus.class));
        item = this.buildDomElementItem(-10000L);
        stage.doExecute((Item)item);
        Assert.assertTrue((boolean)item.getItemMetadata().containsKey(ErrorStatus.class));
        item = this.buildDomElementItem(691200000L);
        stage.doExecute((Item)item);
        Assert.assertTrue((boolean)item.getItemMetadata().containsKey(ErrorStatus.class));
    }

    private DOMElementItem buildDomElementItem(long validUntilInterval) throws Exception {
        Element descriptor = this.readXMLData("in.xml");
        if (validUntilInterval != 0L) {
            AttributeSupport.appendDateTimeAttribute((Element)descriptor, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME, (long)(System.currentTimeMillis() + validUntilInterval));
        } else {
            AttributeSupport.removeAttribute((Element)descriptor, (QName)SAMLMetadataSupport.VALID_UNTIL_ATTRIB_NAME);
        }
        return new DOMElementItem(descriptor.getOwnerDocument());
    }
}

