/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdattr;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.mdattr.EntityAttributeFilteringStage;
import net.shibboleth.metadata.dom.saml.mdattr.EntityCategoryMatcher;
import net.shibboleth.metadata.dom.saml.mdattr.EntityCategorySupportMatcher;
import net.shibboleth.metadata.dom.saml.mdrpi.RegistrationAuthorityPopulationStage;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class EntityAttributeFilteringStageTest
extends BaseDOMTest {
    protected EntityAttributeFilteringStageTest() {
        super(EntityAttributeFilteringStage.class);
    }

    private Element makeInputDocument() throws Exception {
        return this.readXMLData("input.xml");
    }

    private List<Item<Element>> makeItems(Element inputElement) throws Exception {
        DOMElementItem item = new DOMElementItem(inputElement);
        ArrayList<Item<Element>> items = new ArrayList<Item<Element>>();
        items.add((Item<Element>)item);
        RegistrationAuthorityPopulationStage ras = new RegistrationAuthorityPopulationStage();
        ras.setId("id");
        ras.initialize();
        ras.execute(items);
        ras.destroy();
        return items;
    }

    private List<Item<Element>> makeInputItems() throws Exception {
        return this.makeItems(this.makeInputDocument());
    }

    @Test
    public void testNoPredicates() throws Exception {
        List<Item<Element>> items = this.makeInputItems();
        EntityAttributeFilteringStage stage = new EntityAttributeFilteringStage();
        stage.setId("id");
        stage.initialize();
        stage.execute(items);
        stage.destroy();
        Element result = (Element)items.get(0).unwrap();
        Element expected = this.readXMLData("keepnone.xml");
        this.assertXMLIdentical(expected, result);
    }

    @Test
    public void testKeepCoC() throws Exception {
        List<Item<Element>> items = this.makeInputItems();
        ArrayList<EntityCategoryMatcher> rules = new ArrayList<EntityCategoryMatcher>();
        rules.add(new EntityCategoryMatcher("http://www.geant.net/uri/dataprotection-code-of-conduct/v1"));
        EntityAttributeFilteringStage stage = new EntityAttributeFilteringStage();
        stage.setId("id");
        stage.setRules(rules);
        stage.initialize();
        stage.execute(items);
        stage.destroy();
        Element result = (Element)items.get(0).unwrap();
        Element expected = this.readXMLData("keepcoc.xml");
        this.assertXMLIdentical(expected, result);
    }

    @Test
    public void testKeepCoCRightRegistrar() throws Exception {
        List<Item<Element>> items = this.makeInputItems();
        ArrayList<EntityCategoryMatcher> rules = new ArrayList<EntityCategoryMatcher>();
        rules.add(new EntityCategoryMatcher("http://www.geant.net/uri/dataprotection-code-of-conduct/v1", "http://ukfederation.org.uk"));
        EntityAttributeFilteringStage stage = new EntityAttributeFilteringStage();
        stage.setId("id");
        stage.setRules(rules);
        stage.initialize();
        stage.execute(items);
        stage.destroy();
        Element result = (Element)items.get(0).unwrap();
        Element expected = this.readXMLData("keepcoc.xml");
        this.assertXMLIdentical(expected, result);
    }

    @Test
    public void testKeepCoCWrongRegistrar() throws Exception {
        List<Item<Element>> items = this.makeInputItems();
        ArrayList<EntityCategoryMatcher> rules = new ArrayList<EntityCategoryMatcher>();
        rules.add(new EntityCategoryMatcher("http://www.geant.net/uri/dataprotection-code-of-conduct/v1", "http://not.ukfederation.org.uk"));
        EntityAttributeFilteringStage stage = new EntityAttributeFilteringStage();
        stage.setId("id");
        stage.setRules(rules);
        stage.initialize();
        stage.execute(items);
        stage.destroy();
        Element result = (Element)items.get(0).unwrap();
        Element expected = this.readXMLData("keepnone.xml");
        this.assertXMLIdentical(expected, result);
    }

    @Test
    public void testKeepCoC2() throws Exception {
        List<Item<Element>> items = this.makeInputItems();
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EntityCategoryMatcher("http://www.geant.net/uri/dataprotection-code-of-conduct/v1"));
        rules.add(new EntityCategorySupportMatcher("http://www.geant.net/uri/dataprotection-code-of-conduct/v1"));
        EntityAttributeFilteringStage stage = new EntityAttributeFilteringStage();
        stage.setId("id");
        stage.setRules(rules);
        stage.initialize();
        stage.execute(items);
        stage.destroy();
        Element result = (Element)items.get(0).unwrap();
        Element expected = this.readXMLData("keepcoc2.xml");
        this.assertXMLIdentical(expected, result);
    }

    @Test
    public void testKeepEverything() throws Exception {
        List<Item<Element>> items = this.makeInputItems();
        ArrayList<Predicate> rules = new ArrayList<Predicate>();
        rules.add(Predicates.alwaysTrue());
        EntityAttributeFilteringStage stage = new EntityAttributeFilteringStage();
        stage.setId("id");
        stage.setRules(rules);
        stage.initialize();
        stage.execute(items);
        stage.destroy();
        Element result = (Element)items.get(0).unwrap();
        Element expected = this.readXMLData("input.xml");
        this.assertXMLIdentical(expected, result);
    }

    @Test
    public void testBlacklist() throws Exception {
        List<Item<Element>> items = this.makeInputItems();
        ArrayList<EntityCategoryMatcher> rules = new ArrayList<EntityCategoryMatcher>();
        rules.add(new EntityCategoryMatcher("http://www.geant.net/uri/dataprotection-code-of-conduct/v1", "http://ukfederation.org.uk"));
        EntityAttributeFilteringStage stage = new EntityAttributeFilteringStage();
        stage.setId("id");
        stage.setWhitelisting(false);
        stage.setRules(rules);
        stage.initialize();
        stage.execute(items);
        stage.destroy();
        Element result = (Element)items.get(0).unwrap();
        Element expected = this.readXMLData("blacklist.xml");
        this.assertXMLIdentical(expected, result);
    }

    @Test
    public void contextImplFour() {
        EntityAttributeFilteringStage.ContextImpl ctx = new EntityAttributeFilteringStage.ContextImpl("a", "b", "c", "d");
        Assert.assertEquals((String)ctx.getValue(), (String)"a");
        Assert.assertEquals((String)ctx.getName(), (String)"b");
        Assert.assertEquals((String)ctx.getNameFormat(), (String)"c");
        Assert.assertEquals((String)ctx.getRegistrationAuthority(), (String)"d");
    }

    @Test
    public void contextImplThree() {
        EntityAttributeFilteringStage.ContextImpl ctx = new EntityAttributeFilteringStage.ContextImpl("a", "b", "c");
        Assert.assertEquals((String)ctx.getValue(), (String)"a");
        Assert.assertEquals((String)ctx.getName(), (String)"b");
        Assert.assertEquals((String)ctx.getNameFormat(), (String)"c");
        Assert.assertNull((Object)ctx.getRegistrationAuthority());
    }

    @Test
    public void contextImplstringFour() {
        EntityAttributeFilteringStage.ContextImpl ctx = new EntityAttributeFilteringStage.ContextImpl("a", "b", "c", "d");
        Assert.assertEquals((String)ctx.toString(), (String)"{v=a, n=b, f=c, r=d}");
    }

    @Test
    public void contextImplstringThree() {
        EntityAttributeFilteringStage.ContextImpl ctx = new EntityAttributeFilteringStage.ContextImpl("a", "b", "c");
        Assert.assertEquals((String)ctx.toString(), (String)"{v=a, n=b, f=c, r=(none)}");
    }

    @Test
    public void testMDA168_1() throws Exception {
        List<Item<Element>> items = this.makeItems(this.readXMLData("multicon.xml"));
        ArrayList<EntityCategoryMatcher> rules = new ArrayList<EntityCategoryMatcher>();
        rules.add(new EntityCategoryMatcher("http://www.geant.net/uri/dataprotection-code-of-conduct/v1"));
        EntityAttributeFilteringStage stage = new EntityAttributeFilteringStage();
        stage.setId("id");
        stage.setRules(rules);
        stage.initialize();
        stage.execute(items);
        stage.destroy();
        Element result = (Element)items.get(0).unwrap();
        Element expected = this.readXMLData("multiout.xml");
        this.assertXMLIdentical(expected, result);
    }

    @Test
    public void testMDA168_2() throws Exception {
        List<Item<Element>> items = this.makeItems(this.readXMLData("multi2in.xml"));
        ArrayList<EntityCategoryMatcher> rules = new ArrayList<EntityCategoryMatcher>();
        rules.add(new EntityCategoryMatcher("http://refeds.org/category/research-and-scholarship"));
        EntityAttributeFilteringStage stage = new EntityAttributeFilteringStage();
        stage.setId("id");
        stage.setRules(rules);
        stage.initialize();
        stage.execute(items);
        stage.destroy();
        Element result = (Element)items.get(0).unwrap();
        Element expected = this.readXMLData("multi2out.xml");
        this.assertXMLIdentical(expected, result);
    }
}

