/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdattr;

import com.google.common.base.Predicate;
import net.shibboleth.metadata.dom.saml.mdattr.EntityAttributeFilteringStage;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.Assert;
import org.testng.annotations.Test;

@ContextConfiguration(value={"EntityCategoryMatcherSpringTest-config.xml"})
public class EntityCategoryMatcherSpringTest
extends AbstractTestNGSpringContextTests {
    private void test(boolean expected, Predicate<EntityAttributeFilteringStage.EntityAttributeContext> matcher, EntityAttributeFilteringStage.EntityAttributeContext context) {
        Assert.assertEquals((boolean)matcher.apply((Object)context), (boolean)expected, (String)context.toString());
    }

    @Test
    public void testNoRA() {
        Predicate matcher = (Predicate)this.applicationContext.getBean("categoryMatcherNoRA", Predicate.class);
        this.test(true, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", "whatever"));
        this.test(true, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category2", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category-support", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", null));
    }

    @Test
    public void testWithRA() {
        Predicate matcher = (Predicate)this.applicationContext.getBean("categoryMatcherWithRA", Predicate.class);
        this.test(true, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", "registrar"));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category2", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", "registrar"));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category-support", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", "registrar"));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", "registrar"));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", "registrar2"));
    }
}

