/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdattr;

import com.google.common.base.Predicate;
import net.shibboleth.metadata.dom.saml.mdattr.EntityAttributeFilteringStage;
import net.shibboleth.metadata.dom.saml.mdattr.EntityCategoryMatcher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EntityCategoryMatcherTest {
    private void test(boolean expected, Predicate<EntityAttributeFilteringStage.EntityAttributeContext> matcher, EntityAttributeFilteringStage.EntityAttributeContext context) {
        Assert.assertEquals((boolean)matcher.apply((Object)context), (boolean)expected, (String)context.toString());
    }

    @Test
    public void testNoRA() {
        EntityCategoryMatcher matcher = new EntityCategoryMatcher("category");
        this.test(true, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", "whatever"));
        this.test(true, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category2", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category-support", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", null));
    }

    @Test
    public void testWithRA() {
        EntityCategoryMatcher matcher = new EntityCategoryMatcher("category", "registrar");
        this.test(true, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", "registrar"));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", null));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category2", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", "registrar"));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category-support", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", "registrar"));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified", "registrar"));
        this.test(false, (Predicate<EntityAttributeFilteringStage.EntityAttributeContext>)matcher, (EntityAttributeFilteringStage.EntityAttributeContext)new EntityAttributeFilteringStage.ContextImpl("category", "http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri", "registrar2"));
    }
}

