/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdrpi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.mdrpi.EntityRegistrationAuthorityFilterStage;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EntityRegistrationAuthorityFilterStageTest
extends BaseDOMTest {
    public EntityRegistrationAuthorityFilterStageTest() {
        super(EntityRegistrationAuthorityFilterStage.class);
    }

    @Test
    public void testAuthorityWhitelist() throws Exception {
        EntityRegistrationAuthorityFilterStage stage = new EntityRegistrationAuthorityFilterStage();
        stage.setId("test");
        stage.setRequiringRegistrationInformation(false);
        stage.setWhitelistingRegistrationAuthorities(true);
        stage.setDesignatedRegistrationAuthorities(Collections.singletonList("urn:example.org:authority2"));
        stage.initialize();
        Collection<Item<Element>> mdCollection = this.buildMetadataCollection();
        Assert.assertEquals((int)mdCollection.size(), (int)3);
        stage.execute(mdCollection);
        Assert.assertEquals((int)mdCollection.size(), (int)2);
    }

    @Test
    public void testAuthorityBlacklist() throws Exception {
        EntityRegistrationAuthorityFilterStage stage = new EntityRegistrationAuthorityFilterStage();
        stage.setId("test");
        stage.setWhitelistingRegistrationAuthorities(false);
        stage.setRequiringRegistrationInformation(false);
        stage.setDesignatedRegistrationAuthorities(Collections.singletonList("urn:example.org:authority2"));
        stage.initialize();
        Collection<Item<Element>> mdCollection = this.buildMetadataCollection();
        Assert.assertEquals((int)mdCollection.size(), (int)3);
        stage.execute(mdCollection);
        Assert.assertEquals((int)mdCollection.size(), (int)1);
    }

    @Test
    public void testRequireRegistrationInfo() throws Exception {
        EntityRegistrationAuthorityFilterStage stage = new EntityRegistrationAuthorityFilterStage();
        stage.setId("test");
        stage.setRequiringRegistrationInformation(true);
        stage.setWhitelistingRegistrationAuthorities(false);
        stage.setDesignatedRegistrationAuthorities(Arrays.asList("urn:example.org:authority1", "urn:example.org:authority2"));
        stage.initialize();
        ArrayList<DOMElementItem> mdCollection = new ArrayList<DOMElementItem>();
        mdCollection.add(new DOMElementItem(this.readXMLData("in.xml")));
        Assert.assertEquals((int)mdCollection.size(), (int)1);
        stage.execute(mdCollection);
        Assert.assertEquals((int)mdCollection.size(), (int)0);
    }

    @Test
    public void testRemoveEntitylessEntitiesDescriptor() throws Exception {
        EntityRegistrationAuthorityFilterStage stage = new EntityRegistrationAuthorityFilterStage();
        stage.setId("test");
        stage.setRequiringRegistrationInformation(true);
        stage.setRemovingEntitylessEntitiesDescriptor(true);
        stage.setWhitelistingRegistrationAuthorities(false);
        stage.setDesignatedRegistrationAuthorities(Arrays.asList("urn:example.org:authority1", "urn:example.org:authority2"));
        stage.initialize();
        ArrayList<DOMElementItem> mdCollection = new ArrayList<DOMElementItem>();
        mdCollection.add(new DOMElementItem(this.readXMLData("in.xml")));
        Assert.assertEquals((int)mdCollection.size(), (int)1);
        stage.execute(mdCollection);
        Assert.assertEquals((int)mdCollection.size(), (int)0);
    }

    @Test
    public void testDontRemoveEntitylessEntitiesDescriptor() throws Exception {
        EntityRegistrationAuthorityFilterStage stage = new EntityRegistrationAuthorityFilterStage();
        stage.setId("test");
        stage.setRemovingEntitylessEntitiesDescriptor(false);
        stage.setRequiringRegistrationInformation(false);
        stage.setWhitelistingRegistrationAuthorities(false);
        stage.setDesignatedRegistrationAuthorities(Arrays.asList("urn:example.org:authority1", "urn:example.org:authority2"));
        stage.initialize();
        ArrayList<DOMElementItem> mdCollection = new ArrayList<DOMElementItem>();
        mdCollection.add(new DOMElementItem(this.readXMLData("in.xml")));
        Assert.assertEquals((int)mdCollection.size(), (int)1);
        stage.execute(mdCollection);
        Assert.assertEquals((int)mdCollection.size(), (int)1);
        Assert.assertEquals((int)ElementSupport.getChildElements((Node)((Node)((Item)mdCollection.get(0)).unwrap())).size(), (int)0);
    }

    private Collection<Item<Element>> buildMetadataCollection() throws Exception {
        ArrayList<Item<Element>> metadataCollection = new ArrayList<Item<Element>>();
        List descriptors = ElementSupport.getChildElements((Node)this.readXMLData("in.xml"));
        for (Element descriptor : descriptors) {
            metadataCollection.add((Item<Element>)new DOMElementItem(descriptor));
        }
        return metadataCollection;
    }
}

