/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdrpi;

import java.util.HashMap;
import java.util.HashSet;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.dom.saml.mdrpi.RegistrationAuthority;
import net.shibboleth.metadata.dom.saml.mdrpi.RegistrationAuthorityItemIdentificationStrategy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RegistrationAuthorityItemIdentificationStrategyTest {
    private RegistrationAuthorityItemIdentificationStrategy makeStrat() {
        RegistrationAuthorityItemIdentificationStrategy strat = new RegistrationAuthorityItemIdentificationStrategy();
        strat.setNoItemIdIdentifier("mu");
        return strat;
    }

    @Test
    public void base_unidentified() {
        RegistrationAuthorityItemIdentificationStrategy strat = new RegistrationAuthorityItemIdentificationStrategy();
        Assert.assertEquals((String)strat.getNoItemIdIdentifier(), (String)"unidentified");
        MockItem item = new MockItem("item");
        String res = strat.getItemIdentifier((Item)item);
        Assert.assertEquals((String)res, (String)"unidentified");
    }

    @Test
    public void base_setNoItemIdIdentifier() {
        RegistrationAuthorityItemIdentificationStrategy strat = this.makeStrat();
        strat.setNoItemIdIdentifier("mu2");
        Assert.assertEquals((String)strat.getNoItemIdIdentifier(), (String)"mu2");
        MockItem item = new MockItem("item");
        String res = strat.getItemIdentifier((Item)item);
        Assert.assertEquals((String)res, (String)"mu2");
    }

    @Test
    public void base_oneIdentifier() {
        RegistrationAuthorityItemIdentificationStrategy strat = this.makeStrat();
        MockItem item = new MockItem("item");
        item.getItemMetadata().put((Object)new ItemId("id"));
        String res = strat.getItemIdentifier((Item)item);
        Assert.assertEquals((String)res, (String)"id");
    }

    @Test
    public void base_twoIdentifiers() {
        RegistrationAuthorityItemIdentificationStrategy strat = this.makeStrat();
        MockItem item = new MockItem("item");
        item.getItemMetadata().put((Object)new ItemId("first"));
        item.getItemMetadata().put((Object)new ItemId("second"));
        String res = strat.getItemIdentifier((Item)item);
        Assert.assertEquals((String)res, (String)"first");
    }

    @Test
    public void getItemIdentifier() {
        RegistrationAuthorityItemIdentificationStrategy strat = this.makeStrat();
        MockItem item2 = new MockItem("item 2");
        Assert.assertEquals((String)strat.getItemIdentifier((Item)item2), (String)"mu");
        item2.getItemMetadata().put((Object)new ItemId("item-id"));
        Assert.assertEquals((String)strat.getItemIdentifier((Item)item2), (String)"item-id");
    }

    @Test
    public void withRegistrationAuthority() throws Exception {
        RegistrationAuthorityItemIdentificationStrategy strat = this.makeStrat();
        MockItem item = new MockItem("present");
        item.getItemMetadata().put((Object)new ItemId("uk002232"));
        item.getItemMetadata().put((Object)new RegistrationAuthority("http://ukfederation.org.uk"));
        Assert.assertEquals((String)strat.getItemIdentifier((Item)item), (String)"uk002232 (http://ukfederation.org.uk)");
    }

    @Test
    public void ignoredAuthority() throws Exception {
        RegistrationAuthorityItemIdentificationStrategy strat = this.makeStrat();
        MockItem item = new MockItem("present");
        item.getItemMetadata().put((Object)new ItemId("uk002232"));
        item.getItemMetadata().put((Object)new RegistrationAuthority("http://ukfederation.org.uk"));
        HashSet<String> auths = new HashSet<String>();
        auths.add("http://ukfederation.org.uk");
        strat.setIgnoredRegistrationAuthorities(auths);
        Assert.assertEquals((String)strat.getItemIdentifier((Item)item), (String)"uk002232");
    }

    @Test
    public void mappedAuthority() throws Exception {
        RegistrationAuthorityItemIdentificationStrategy strat = this.makeStrat();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("http://ukfederation.org.uk", "UKf");
        strat.setRegistrationAuthorityDisplayNames(nameMap);
        MockItem item = new MockItem("present");
        item.getItemMetadata().put((Object)new ItemId("uk002232"));
        item.getItemMetadata().put((Object)new RegistrationAuthority("http://ukfederation.org.uk"));
        Assert.assertEquals((String)strat.getItemIdentifier((Item)item), (String)"uk002232 (UKf)");
    }
}

