/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom.saml.mdrpi;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.dom.BaseDOMTest;
import net.shibboleth.metadata.dom.DOMElementItem;
import net.shibboleth.metadata.dom.saml.mdrpi.RegistrationAuthority;
import net.shibboleth.metadata.dom.saml.mdrpi.RegistrationAuthorityPopulationStage;
import net.shibboleth.utilities.java.support.collection.ClassToInstanceMultiMap;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class RegistrationAuthorityPopulationStageTest
extends BaseDOMTest {
    public RegistrationAuthorityPopulationStageTest() {
        super(RegistrationAuthorityPopulationStage.class);
    }

    private RegistrationAuthorityPopulationStage makeStage() throws ComponentInitializationException {
        RegistrationAuthorityPopulationStage stage = new RegistrationAuthorityPopulationStage();
        stage.setId("test");
        stage.initialize();
        return stage;
    }

    private DOMElementItem makeItem(String which) throws XMLParserException {
        Element doc = this.readXMLData(this.classRelativeResource(which + ".xml"));
        return new DOMElementItem(doc);
    }

    @Test
    public void populatePresent() throws Exception {
        DOMElementItem item = this.makeItem("present");
        ArrayList<DOMElementItem> items = new ArrayList<DOMElementItem>();
        items.add(item);
        RegistrationAuthorityPopulationStage stage = this.makeStage();
        stage.execute(items);
        ClassToInstanceMultiMap metadata = item.getItemMetadata();
        List errors = metadata.get(ErrorStatus.class);
        Assert.assertEquals((int)errors.size(), (int)0);
        List regAuths = metadata.get(RegistrationAuthority.class);
        Assert.assertEquals((int)regAuths.size(), (int)1);
        RegistrationAuthority regAuth = (RegistrationAuthority)regAuths.get(0);
        Assert.assertEquals((String)regAuth.getRegistrationAuthority(), (String)"http://ukfederation.org.uk");
    }

    @Test
    public void populateAbsent() throws Exception {
        DOMElementItem item = this.makeItem("absent");
        ArrayList<DOMElementItem> items = new ArrayList<DOMElementItem>();
        items.add(item);
        RegistrationAuthorityPopulationStage stage = this.makeStage();
        stage.execute(items);
        ClassToInstanceMultiMap metadata = item.getItemMetadata();
        List errors = metadata.get(ErrorStatus.class);
        Assert.assertEquals((int)errors.size(), (int)0);
        List regAuths = metadata.get(RegistrationAuthority.class);
        Assert.assertEquals((int)regAuths.size(), (int)0);
    }

    @Test
    public void populateNoExtensions() throws Exception {
        DOMElementItem item = this.makeItem("noext");
        ArrayList<DOMElementItem> items = new ArrayList<DOMElementItem>();
        items.add(item);
        RegistrationAuthorityPopulationStage stage = this.makeStage();
        stage.execute(items);
        ClassToInstanceMultiMap metadata = item.getItemMetadata();
        List errors = metadata.get(ErrorStatus.class);
        Assert.assertEquals((int)errors.size(), (int)0);
        List regAuths = metadata.get(RegistrationAuthority.class);
        Assert.assertEquals((int)regAuths.size(), (int)0);
    }
}

