/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.pipeline.AtLeastCollectionPredicate;
import net.shibboleth.metadata.pipeline.CountingStage;
import net.shibboleth.metadata.pipeline.SimplePipeline;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BaseStageTest {
    @Test
    public void getSetCollectionPredicate() {
        CountingStage c = new CountingStage();
        Predicate pred = c.getCollectionPredicate();
        ArrayList list = new ArrayList();
        Assert.assertTrue((boolean)pred.apply(list));
        Predicate pred2 = Predicates.alwaysFalse();
        Assert.assertNotSame((Object)pred, (Object)pred2);
        c.setCollectionPredicate(pred2);
        Assert.assertSame((Object)c.getCollectionPredicate(), (Object)pred2);
    }

    @Test
    public void conditionalExecution() throws Exception {
        MockItem md1 = new MockItem("one");
        MockItem md2 = new MockItem("two");
        ArrayList<MockItem> items = new ArrayList<MockItem>();
        items.add(md1);
        items.add(md2);
        AtLeastCollectionPredicate pred2 = new AtLeastCollectionPredicate();
        pred2.setMinimum(2);
        CountingStage stage2 = new CountingStage();
        stage2.setCollectionPredicate((Predicate)pred2);
        AtLeastCollectionPredicate pred3 = new AtLeastCollectionPredicate();
        pred3.setMinimum(3);
        CountingStage stage3 = new CountingStage();
        stage3.setCollectionPredicate((Predicate)pred3);
        ArrayList stages = new ArrayList();
        stages.add(stage2);
        stages.add(stage3);
        SimplePipeline pipeline = new SimplePipeline();
        pipeline.setId("test");
        pipeline.setStages(stages);
        pipeline.initialize();
        pipeline.execute(items);
        Assert.assertEquals((int)stage2.getInvocationCount(), (int)1);
        Assert.assertEquals((int)stage2.getItemCount(), (int)2);
        Assert.assertEquals((int)stage3.getInvocationCount(), (int)0);
        Assert.assertEquals((int)stage3.getItemCount(), (int)0);
    }
}

