/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Function;
import com.google.common.io.Files;
import java.io.File;
import java.io.OutputStream;
import junit.framework.Assert;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.pipeline.FilesInDirectoryMultiOutputStrategy;
import net.shibboleth.metadata.pipeline.MultiOutputSerializationStage;
import org.testng.annotations.Test;

public class FilesInDirectoryMultiOutputStrategyTest {
    private void wipeDirectory(File dir) {
        for (File file : dir.listFiles()) {
            file.delete();
        }
        dir.delete();
    }

    private void checkOneFile(File dir, String expectedName) {
        File[] files = dir.listFiles();
        Assert.assertEquals((int)1, (int)files.length);
        Assert.assertEquals((String)expectedName, (String)files[0].getName());
    }

    @Test
    public void testFull() throws Exception {
        File tempDir = Files.createTempDir();
        FilesInDirectoryMultiOutputStrategy strategy = new FilesInDirectoryMultiOutputStrategy();
        strategy.setDirectory(tempDir);
        strategy.setNamePrefix("pre");
        strategy.setNameTransformer((Function)new Function<String, String>(){

            public String apply(String input) {
                return input + input;
            }
        });
        strategy.setNameSuffix(".txt");
        strategy.initialize();
        MockItem item = new MockItem("mocked");
        item.getItemMetadata().put((Object)new ItemId("abc"));
        MultiOutputSerializationStage.Destination dest = strategy.getDestination((Item)item);
        OutputStream os = dest.getOutputStream();
        os.write(97);
        os.close();
        dest.close();
        this.checkOneFile(tempDir, "preabcabc.txt");
        this.wipeDirectory(tempDir);
    }

    @Test
    public void testDefaults() throws Exception {
        File tempDir = Files.createTempDir();
        FilesInDirectoryMultiOutputStrategy strategy = new FilesInDirectoryMultiOutputStrategy();
        strategy.setDirectory(tempDir);
        strategy.initialize();
        MockItem item = new MockItem("mocked");
        item.getItemMetadata().put((Object)new ItemId("abc"));
        MultiOutputSerializationStage.Destination dest = strategy.getDestination((Item)item);
        OutputStream os = dest.getOutputStream();
        os.write(97);
        os.close();
        dest.close();
        this.checkOneFile(tempDir, "abc");
        this.wipeDirectory(tempDir);
    }
}

