/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.pipeline.ComponentInfo;
import net.shibboleth.metadata.pipeline.ItemIdTransformStage;
import net.shibboleth.metadata.pipeline.MDQueryMD5ItemIdTransformer;
import net.shibboleth.metadata.pipeline.MDQuerySHA1ItemIdTransformer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ItemIdTransformStageTest {
    @Test
    public void test() throws Exception {
        MockItem item = new MockItem("test");
        item.getItemMetadata().put((Object)new ItemId("http://example.org"));
        ArrayList<MockItem> mdColl = new ArrayList<MockItem>();
        mdColl.add(item);
        ArrayList<Object> transforms = new ArrayList<Object>();
        transforms.add(new MDQueryMD5ItemIdTransformer());
        transforms.add(new MDQuerySHA1ItemIdTransformer());
        ItemIdTransformStage stage = new ItemIdTransformStage();
        stage.setId("test");
        stage.setIdTransformers(transforms);
        Assert.assertFalse((boolean)stage.isInitialized());
        stage.initialize();
        Assert.assertTrue((boolean)stage.isInitialized());
        stage.execute(mdColl);
        Assert.assertEquals((int)mdColl.size(), (int)1);
        Assert.assertEquals((int)item.getItemMetadata().values().size(), (int)4);
        ComponentInfo compInfo = (ComponentInfo)item.getItemMetadata().get(ComponentInfo.class).get(0);
        Assert.assertNotNull((Object)compInfo.getCompleteInstant());
        Assert.assertEquals((String)compInfo.getComponentId(), (String)"test");
        Assert.assertEquals((Object)compInfo.getComponentType(), ItemIdTransformStage.class);
        Assert.assertNotNull((Object)compInfo.getStartInstant());
        List idInfos = item.getItemMetadata().get(ItemId.class);
        Assert.assertEquals((int)idInfos.size(), (int)3);
        boolean idMatch = false;
        boolean sha1Match = false;
        boolean md5Match = false;
        for (ItemId info : idInfos) {
            String id = info.getId();
            if (id.startsWith("{sha1}")) {
                Assert.assertFalse((boolean)sha1Match);
                sha1Match = "{sha1}ff7c1f10ab54968058fdcfaadf1b2457cd5d1a3f".equals(id);
                continue;
            }
            if (id.startsWith("{md5}")) {
                Assert.assertFalse((boolean)md5Match);
                md5Match = "{md5}dab521de65f9250b4cca7383feef67dc".equals(id);
                continue;
            }
            Assert.assertFalse((boolean)idMatch);
            idMatch = "http://example.org".equals(id);
        }
        Assert.assertTrue((boolean)idMatch);
        Assert.assertTrue((boolean)sha1Match);
        Assert.assertTrue((boolean)md5Match);
    }
}

