/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.ItemSerializer;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.pipeline.MultiOutputSerializationStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.testng.annotations.Test;

public class MultiOutputSerializationStageTest {
    @Test
    public void basicTest() throws Exception {
        MockItem aaaItem = new MockItem("aaaContent");
        aaaItem.getItemMetadata().put((Object)new ItemId("aaa"));
        MockItem bbbItem = new MockItem("bbbContent");
        bbbItem.getItemMetadata().put((Object)new ItemId("bbb"));
        MockItem cccItem = new MockItem("cccContent");
        cccItem.getItemMetadata().put((Object)new ItemId("ccc"));
        ArrayList<MockItem> items = new ArrayList<MockItem>();
        items.add(aaaItem);
        items.add(cccItem);
        items.add(bbbItem);
        StringMapOutputStrategy strategy = new StringMapOutputStrategy();
        MultiOutputSerializationStage stage = new MultiOutputSerializationStage();
        stage.setId("test");
        stage.setOutputStrategy((MultiOutputSerializationStage.OutputStrategy)strategy);
        stage.setSerializer((ItemSerializer)new ItemSerializer<String>(){

            public void serialize(Item<String> item, OutputStream output) {
                try {
                    output.write(((String)item.unwrap()).getBytes("UTF-8"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        stage.initialize();
        stage.execute(items);
        Map<String, String> map = strategy.map;
        Assert.assertEquals((int)3, (int)map.size());
        Assert.assertEquals((String)"aaaContent", (String)map.get("aaa"));
        Assert.assertEquals((String)"bbbContent", (String)map.get("bbb"));
        Assert.assertEquals((String)"cccContent", (String)map.get("ccc"));
    }

    private static class StringMapOutputStrategy
    implements MultiOutputSerializationStage.OutputStrategy<String> {
        public final Map<String, String> map = new HashMap<String, String>();

        private StringMapOutputStrategy() {
        }

        public MultiOutputSerializationStage.Destination getDestination(Item<String> item) throws StageProcessingException {
            List ids = item.getItemMetadata().get(ItemId.class);
            if (ids.isEmpty()) {
                throw new StageProcessingException("item has no ItemId to base a file name on");
            }
            ItemId id = (ItemId)ids.get(0);
            return new StringDestination(id.getId());
        }

        private class StringDestination
        implements MultiOutputSerializationStage.Destination {
            private final String id;
            private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

            public StringDestination(String i) {
                this.id = i;
            }

            public void close() throws IOException {
                StringMapOutputStrategy.this.map.put(this.id, this.baos.toString("UTF-8"));
            }

            public OutputStream getOutputStream() throws IOException {
                return this.baos;
            }
        }
    }
}

