/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.SimpleItemCollectionFactory;
import net.shibboleth.metadata.pipeline.CountingStage;
import net.shibboleth.metadata.pipeline.PipelineDemultiplexerStage;
import net.shibboleth.metadata.pipeline.SimplePipeline;
import net.shibboleth.metadata.pipeline.TerminatingStage;
import net.shibboleth.metadata.pipeline.TerminationException;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PipelineDemultiplexerStageTest {
    @Test
    public void testCollectionFactory() {
        PipelineDemultiplexerStage stage = new PipelineDemultiplexerStage();
        SimpleItemCollectionFactory factory = new SimpleItemCollectionFactory();
        stage.setCollectionFactory((Supplier)factory);
        Assert.assertEquals((Object)stage.getCollectionFactory(), (Object)factory);
    }

    @Test
    public void testExecutorService() {
        PipelineDemultiplexerStage stage = new PipelineDemultiplexerStage();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        stage.setExecutorService(executor);
        Assert.assertEquals((Object)stage.getExecutorService(), (Object)executor);
    }

    @Test
    public void testPipelineAndSelectionStrategies() {
        PipelineDemultiplexerStage stage = new PipelineDemultiplexerStage();
        ArrayList pass = new ArrayList();
        stage.setPipelineAndSelectionStrategies(pass);
        Assert.assertEquals((Collection)stage.getPipelineAndSelectionStrategies(), pass);
    }

    @Test
    public void testWaitingForPipelines() {
        PipelineDemultiplexerStage stage = new PipelineDemultiplexerStage();
        stage.setWaitingForPipelines(true);
        Assert.assertTrue((boolean)stage.isWaitingForPipelines());
    }

    @Test
    public void testInitialize() throws Exception {
        SimplePipeline pipeline = new SimplePipeline();
        pipeline.setId("pipeline");
        PipelineDemultiplexerStage stage = new PipelineDemultiplexerStage();
        stage.setId("test");
        stage.setPipelineAndSelectionStrategies(Collections.singletonList(new Pair((Object)pipeline, (Object)Predicates.alwaysTrue())));
        stage.initialize();
        Assert.assertNotNull((Object)stage.getCollectionFactory());
        Assert.assertNotNull((Object)stage.getExecutorService());
        try {
            stage = new PipelineDemultiplexerStage();
            stage.setId("test");
            stage.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void testExecute() throws Exception {
        SimplePipeline pipeline = new SimplePipeline();
        pipeline.setId("selectedPipeline");
        CountingStage countStage = new CountingStage();
        pipeline.setStages(Collections.singletonList(countStage));
        ArrayList<MockItem> items = new ArrayList<MockItem>();
        items.add(new MockItem("one"));
        items.add(new MockItem("two"));
        items.add(new MockItem("three"));
        PipelineDemultiplexerStage stage = new PipelineDemultiplexerStage();
        stage.setId("test");
        stage.setWaitingForPipelines(true);
        stage.setPipelineAndSelectionStrategies(Collections.singletonList(new Pair((Object)pipeline, (Object)Predicates.alwaysTrue())));
        stage.initialize();
        stage.execute(items);
        Assert.assertEquals((int)countStage.getInvocationCount(), (int)1);
    }

    @Test
    public void testThrow() throws Exception {
        SimplePipeline pipeline = new SimplePipeline();
        pipeline.setId("selectedPipeline");
        TerminatingStage terminatingStage = new TerminatingStage();
        pipeline.setStages(Collections.singletonList(terminatingStage));
        ArrayList<MockItem> items = new ArrayList<MockItem>();
        items.add(new MockItem("one"));
        items.add(new MockItem("two"));
        items.add(new MockItem("three"));
        PipelineDemultiplexerStage stage = new PipelineDemultiplexerStage();
        stage.setId("test");
        stage.setWaitingForPipelines(true);
        stage.setPipelineAndSelectionStrategies(Collections.singletonList(new Pair((Object)pipeline, (Object)Predicates.alwaysTrue())));
        stage.initialize();
        try {
            stage.execute(items);
            Assert.fail((String)"expected exception to be thrown");
        }
        catch (TerminationException terminationException) {
            // empty catch block
        }
    }
}

