/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.DeduplicatingItemIdMergeStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.pipeline.PipelineMergeStage;
import net.shibboleth.metadata.pipeline.SimplePipeline;
import net.shibboleth.metadata.pipeline.StaticItemSourceStage;
import net.shibboleth.metadata.pipeline.TerminatingStage;
import net.shibboleth.metadata.pipeline.TerminationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PipelineMergeStageTest {
    private <T> List<T> newSingletonList(T element) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(element);
        return list;
    }

    private <T> List<T> newTwoElementList(T element1, T element2) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(element1);
        list.add(element2);
        return list;
    }

    @Test
    public void test() throws Exception {
        MockItem md1 = new MockItem("one");
        StaticItemSourceStage source1 = new StaticItemSourceStage();
        source1.setId("src1");
        source1.setSourceItems(this.newSingletonList(md1));
        SimplePipeline pipeline1 = new SimplePipeline();
        pipeline1.setId("p1");
        pipeline1.setStages(this.newSingletonList(source1));
        MockItem md2 = new MockItem("two");
        StaticItemSourceStage source2 = new StaticItemSourceStage();
        source2.setId("src2");
        source2.setSourceItems(this.newSingletonList(md2));
        SimplePipeline pipeline2 = new SimplePipeline();
        pipeline2.setId("p2");
        pipeline2.setStages(this.newSingletonList(source2));
        ArrayList<SimplePipeline> joinedPipelines = new ArrayList<SimplePipeline>();
        joinedPipelines.add(pipeline1);
        joinedPipelines.add(pipeline2);
        PipelineMergeStage joinSource = new PipelineMergeStage();
        joinSource.setId("joinSource");
        joinSource.setMergedPipelines(this.newTwoElementList(pipeline1, pipeline2));
        Assert.assertFalse((boolean)joinSource.isInitialized());
        Assert.assertFalse((boolean)pipeline1.isInitialized());
        Assert.assertFalse((boolean)pipeline2.isInitialized());
        joinSource.initialize();
        Assert.assertTrue((boolean)joinSource.isInitialized());
        Assert.assertTrue((boolean)pipeline1.isInitialized());
        Assert.assertTrue((boolean)pipeline2.isInitialized());
        ArrayList metadataCollection = new ArrayList();
        joinSource.execute(metadataCollection);
        Assert.assertEquals((int)metadataCollection.size(), (int)2);
        boolean md1CloneMatch = false;
        boolean md2CloneMatch = false;
        for (Item metadata : metadataCollection) {
            if ("one".equals(metadata.unwrap())) {
                md1CloneMatch = true;
                Assert.assertFalse((metadata == md1 ? 1 : 0) != 0);
            } else if ("two".equals(metadata.unwrap())) {
                md2CloneMatch = true;
                Assert.assertFalse((metadata == md2 ? 1 : 0) != 0);
            }
            Assert.assertEquals((int)metadata.getItemMetadata().values().size(), (int)3);
        }
        Assert.assertTrue((boolean)md1CloneMatch);
        Assert.assertTrue((boolean)md2CloneMatch);
    }

    @Test
    public void testDediplicatingItemIdMergeStrategySingleSource() {
        DeduplicatingItemIdMergeStrategy strategy = new DeduplicatingItemIdMergeStrategy();
        ArrayList<MockItem> target = new ArrayList<MockItem>();
        MockItem item1 = new MockItem("item1");
        target.add(item1);
        MockItem item2 = new MockItem("item2");
        item2.getItemMetadata().put((Object)new ItemId("itemA"));
        target.add(item2);
        MockItem item3 = new MockItem("item3");
        item3.getItemMetadata().put((Object)new ItemId("itemB"));
        item3.getItemMetadata().put((Object)new ItemId("itemC"));
        target.add(item3);
        ArrayList<MockItem> source1 = new ArrayList<MockItem>();
        MockItem item4 = new MockItem("item4");
        item4.getItemMetadata().put((Object)new ItemId("itemD"));
        source1.add(item4);
        MockItem item5 = new MockItem("item5");
        item5.getItemMetadata().put((Object)new ItemId("itemA"));
        source1.add(item5);
        MockItem item6 = new MockItem("item6");
        source1.add(item6);
        ArrayList<ArrayList<MockItem>> sources = new ArrayList<ArrayList<MockItem>>();
        sources.add(source1);
        strategy.mergeCollection(target, sources);
        Assert.assertTrue((boolean)target.contains((Object)item1));
        Assert.assertTrue((boolean)target.contains((Object)item2));
        Assert.assertTrue((boolean)target.contains((Object)item3));
        Assert.assertTrue((boolean)target.contains((Object)item4));
        Assert.assertFalse((boolean)target.contains((Object)item5));
        Assert.assertTrue((boolean)target.contains((Object)item6));
        Assert.assertEquals((int)target.size(), (int)5);
    }

    @Test
    public void testDediplicatingItemIdMergeStrategyMultipleSource() {
        DeduplicatingItemIdMergeStrategy strategy = new DeduplicatingItemIdMergeStrategy();
        ArrayList<MockItem> target = new ArrayList<MockItem>();
        MockItem item1 = new MockItem("item1");
        target.add(item1);
        MockItem item2 = new MockItem("item2");
        item2.getItemMetadata().put((Object)new ItemId("itemA"));
        target.add(item2);
        MockItem item3 = new MockItem("item3");
        item3.getItemMetadata().put((Object)new ItemId("itemB"));
        item3.getItemMetadata().put((Object)new ItemId("itemC"));
        target.add(item3);
        ArrayList<MockItem> source1 = new ArrayList<MockItem>();
        MockItem item4 = new MockItem("item4");
        item4.getItemMetadata().put((Object)new ItemId("itemD"));
        source1.add(item4);
        MockItem item5 = new MockItem("item5");
        item5.getItemMetadata().put((Object)new ItemId("itemA"));
        source1.add(item5);
        MockItem item6 = new MockItem("item6");
        source1.add(item6);
        ArrayList<MockItem> source2 = new ArrayList<MockItem>();
        MockItem item7 = new MockItem("item7");
        item7.getItemMetadata().put((Object)new ItemId("itemD"));
        source2.add(item7);
        MockItem item8 = new MockItem("item8");
        source2.add(item8);
        MockItem item9 = new MockItem("item9");
        item9.getItemMetadata().put((Object)new ItemId("itemA"));
        source2.add(item9);
        ArrayList<ArrayList<MockItem>> sources = new ArrayList<ArrayList<MockItem>>();
        sources.add(source1);
        sources.add(source2);
        strategy.mergeCollection(target, sources);
        Assert.assertTrue((boolean)target.contains((Object)item1));
        Assert.assertTrue((boolean)target.contains((Object)item2));
        Assert.assertTrue((boolean)target.contains((Object)item3));
        Assert.assertTrue((boolean)target.contains((Object)item4));
        Assert.assertFalse((boolean)target.contains((Object)item5));
        Assert.assertTrue((boolean)target.contains((Object)item6));
        Assert.assertFalse((boolean)target.contains((Object)item7));
        Assert.assertTrue((boolean)target.contains((Object)item8));
        Assert.assertFalse((boolean)target.contains((Object)item9));
        Assert.assertEquals((int)target.size(), (int)6);
    }

    @Test
    public void testThrow() throws Exception {
        MockItem md1 = new MockItem("one");
        StaticItemSourceStage source1 = new StaticItemSourceStage();
        source1.setId("src1");
        source1.setSourceItems(this.newSingletonList(md1));
        SimplePipeline pipeline1 = new SimplePipeline();
        pipeline1.setId("p1");
        pipeline1.setStages(this.newSingletonList(source1));
        MockItem md2 = new MockItem("two");
        StaticItemSourceStage source2 = new StaticItemSourceStage();
        source2.setId("src2");
        source2.setSourceItems(this.newSingletonList(md2));
        TerminatingStage term = new TerminatingStage();
        SimplePipeline pipeline2 = new SimplePipeline();
        pipeline2.setId("p2");
        ArrayList<Object> stages = new ArrayList<Object>();
        stages.add(source2);
        stages.add((Object)term);
        pipeline2.setStages(stages);
        ArrayList<SimplePipeline> joinedPipelines = new ArrayList<SimplePipeline>();
        joinedPipelines.add(pipeline1);
        joinedPipelines.add(pipeline2);
        PipelineMergeStage joinSource = new PipelineMergeStage();
        joinSource.setId("joinSource");
        joinSource.setMergedPipelines(this.newTwoElementList(pipeline1, pipeline2));
        Assert.assertFalse((boolean)joinSource.isInitialized());
        Assert.assertFalse((boolean)pipeline1.isInitialized());
        Assert.assertFalse((boolean)pipeline2.isInitialized());
        joinSource.initialize();
        Assert.assertTrue((boolean)joinSource.isInitialized());
        Assert.assertTrue((boolean)pipeline1.isInitialized());
        Assert.assertTrue((boolean)pipeline2.isInitialized());
        ArrayList metadataCollection = new ArrayList();
        try {
            joinSource.execute(metadataCollection);
            Assert.fail((String)"expected exception not thrown");
        }
        catch (TerminationException terminationException) {
            // empty catch block
        }
    }
}

