/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.pipeline;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.pipeline.ComponentInfo;
import net.shibboleth.metadata.pipeline.CountingStage;
import net.shibboleth.metadata.pipeline.SimplePipeline;
import net.shibboleth.metadata.pipeline.Stage;
import net.shibboleth.metadata.pipeline.StaticItemSourceStage;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SimplePipelineTest {
    @Test
    public void testInitialize() throws Exception {
        List<Stage<String>> stages = this.buildStages();
        SimplePipeline pipeline = new SimplePipeline();
        pipeline.setId(" test ");
        pipeline.setStages(stages);
        Assert.assertEquals((String)pipeline.getId(), (String)"test");
        Assert.assertFalse((pipeline.getStages() == stages ? 1 : 0) != 0);
        Assert.assertEquals((int)pipeline.getStages().size(), (int)3);
        Assert.assertTrue((boolean)pipeline.getStages().containsAll(stages));
        Assert.assertFalse((boolean)((Stage)pipeline.getStages().get(0)).isInitialized());
        Assert.assertFalse((boolean)((Stage)pipeline.getStages().get(1)).isInitialized());
        pipeline.initialize();
        Assert.assertEquals((String)pipeline.getId(), (String)"test");
        Assert.assertFalse((pipeline.getStages() == stages ? 1 : 0) != 0);
        Assert.assertEquals((int)pipeline.getStages().size(), (int)3);
        Assert.assertTrue((boolean)pipeline.getStages().containsAll(stages));
        Assert.assertTrue((boolean)((Stage)pipeline.getStages().get(0)).isInitialized());
        Assert.assertTrue((boolean)((Stage)pipeline.getStages().get(1)).isInitialized());
        Assert.assertTrue((boolean)((Stage)pipeline.getStages().get(2)).isInitialized());
        try {
            pipeline = new SimplePipeline();
            pipeline.setStages(stages);
            pipeline.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        try {
            pipeline = new SimplePipeline();
            pipeline.setId("");
            pipeline.setStages(stages);
            pipeline.initialize();
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testExecution() throws Exception {
        List<Stage<String>> stages = this.buildStages();
        SimplePipeline pipeline = new SimplePipeline();
        pipeline.setId("test");
        pipeline.setStages(stages);
        pipeline.initialize();
        ArrayList metadata = new ArrayList();
        pipeline.execute(metadata);
        Assert.assertEquals((int)metadata.size(), (int)2);
        Assert.assertEquals((int)((CountingStage)stages.get(1)).getInvocationCount(), (int)1);
        Assert.assertEquals((int)((CountingStage)stages.get(2)).getInvocationCount(), (int)1);
        Item md = (Item)metadata.iterator().next();
        Assert.assertTrue((boolean)md.getItemMetadata().containsKey(ComponentInfo.class));
        Assert.assertEquals((int)md.getItemMetadata().get(ComponentInfo.class).size(), (int)4);
        try {
            List pipelineStages = pipeline.getStages();
            pipelineStages.clear();
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        metadata.clear();
        pipeline.execute(metadata);
        Assert.assertEquals((int)metadata.size(), (int)2);
        Assert.assertEquals((int)((CountingStage)stages.get(1)).getInvocationCount(), (int)2);
        Assert.assertEquals((int)((CountingStage)stages.get(2)).getInvocationCount(), (int)2);
    }

    protected List<Stage<String>> buildStages() {
        MockItem md1 = new MockItem("one");
        MockItem md2 = new MockItem("two");
        ArrayList<MockItem> items = new ArrayList<MockItem>();
        items.add(md1);
        items.add(md2);
        StaticItemSourceStage source = new StaticItemSourceStage();
        source.setId("src");
        source.setSourceItems(items);
        CountingStage stage1 = new CountingStage();
        CountingStage stage2 = new CountingStage();
        ArrayList<Stage<String>> list = new ArrayList<Stage<String>>();
        list.add((Stage<String>)source);
        list.add((Stage<String>)stage1);
        list.add((Stage<String>)stage2);
        return list;
    }
}

