/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.x509;

import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import net.shibboleth.metadata.BaseTest;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.WarningStatus;
import org.springframework.core.io.Resource;
import org.testng.Assert;

public abstract class BaseX509ValidatorTest
extends BaseTest {
    private CertificateFactory factory = CertificateFactory.getInstance("X.509");

    public BaseX509ValidatorTest(Class<?> clazz) throws Exception {
        super(clazz);
    }

    protected X509Certificate getCertificate(String id) throws Exception {
        Resource certResource = this.getClasspathResource(id);
        X509Certificate cert = (X509Certificate)this.factory.generateCertificate(certResource.getInputStream());
        return cert;
    }

    protected void errorsAndWarnings(Item<?> item, int expectedErrors, int expectedWarnings) {
        List errors = item.getItemMetadata().get(ErrorStatus.class);
        List warnings = item.getItemMetadata().get(WarningStatus.class);
        Assert.assertEquals((int)errors.size(), (int)expectedErrors, (String)"wrong number of errors");
        Assert.assertEquals((int)warnings.size(), (int)expectedWarnings, (String)"wrong number of warnings");
    }
}

