/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.x509;

import java.security.cert.X509Certificate;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.validate.Validator;
import net.shibboleth.metadata.validate.x509.BaseX509ValidatorTest;
import net.shibboleth.metadata.validate.x509.X509RSAExponentValidator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class X509RSAExponentValidatorTest
extends BaseX509ValidatorTest {
    public X509RSAExponentValidatorTest() throws Exception {
        super(X509RSAExponentValidator.class);
    }

    private void testCert(String certName, Validator<X509Certificate> val, int expectedErrors, int expectedWarnings) throws Exception {
        MockItem item = new MockItem("foo");
        X509Certificate cert = this.getCertificate(certName);
        Assert.assertEquals((Object)val.validate((Object)cert, (Item)item, "stage"), (Object)Validator.Action.CONTINUE);
        this.errorsAndWarnings((Item<?>)item, expectedErrors, expectedWarnings);
    }

    private void testThreeCerts(Validator<X509Certificate> val, int expectedErrors3, int expectedWarnings3, int expectedErrors35, int expectedWarnings35, int expectedErrors65537, int expectedWarnings65537) throws Exception {
        this.testCert("3.pem", val, expectedErrors3, expectedWarnings3);
        this.testCert("35.pem", val, expectedErrors35, expectedWarnings35);
        this.testCert("65537.pem", val, expectedErrors65537, expectedWarnings65537);
    }

    @Test
    public void testDefaults() throws Exception {
        X509RSAExponentValidator val = new X509RSAExponentValidator();
        this.testThreeCerts((Validator<X509Certificate>)val, 1, 0, 0, 0, 0, 0);
    }

    @Test
    public void testNISTWarning() throws Exception {
        X509RSAExponentValidator val = new X509RSAExponentValidator();
        val.setWarningBoundary(65537L);
        this.testThreeCerts((Validator<X509Certificate>)val, 1, 0, 0, 1, 0, 0);
    }

    @Test
    public void testNISTError() throws Exception {
        X509RSAExponentValidator val = new X509RSAExponentValidator();
        val.setErrorBoundary(65537L);
        this.testThreeCerts((Validator<X509Certificate>)val, 1, 0, 1, 0, 0, 0);
    }

    @Test
    public void testWarningOnly() throws Exception {
        X509RSAExponentValidator val = new X509RSAExponentValidator();
        val.setErrorBoundary(0L);
        val.setWarningBoundary(65537L);
        this.testThreeCerts((Validator<X509Certificate>)val, 0, 1, 0, 1, 0, 0);
    }
}

