/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.x509;

import java.security.cert.X509Certificate;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.validate.Validator;
import net.shibboleth.metadata.validate.x509.BaseX509ValidatorTest;
import net.shibboleth.metadata.validate.x509.X509RSAKeyLengthValidator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class X509RSAKeyLengthValidatorTest
extends BaseX509ValidatorTest {
    public X509RSAKeyLengthValidatorTest() throws Exception {
        super(X509RSAKeyLengthValidator.class);
    }

    @Test
    public void testDefaults2048() throws Exception {
        MockItem item = new MockItem("foo");
        X509RSAKeyLengthValidator val = new X509RSAKeyLengthValidator();
        X509Certificate cert = this.getCertificate("2048.pem");
        Assert.assertEquals((Object)val.validate((Object)cert, (Item)item, "stage"), (Object)Validator.Action.CONTINUE);
        this.errorsAndWarnings((Item<?>)item, 0, 0);
    }

    @Test
    public void testDefaults1024() throws Exception {
        MockItem item = new MockItem("foo");
        X509RSAKeyLengthValidator val = new X509RSAKeyLengthValidator();
        X509Certificate cert = this.getCertificate("1024.pem");
        Assert.assertEquals((Object)val.validate((Object)cert, (Item)item, "stage"), (Object)Validator.Action.CONTINUE);
        this.errorsAndWarnings((Item<?>)item, 1, 0);
    }

    @Test
    public void testWarningOn1024() throws Exception {
        MockItem item = new MockItem("foo");
        X509RSAKeyLengthValidator val = new X509RSAKeyLengthValidator();
        val.setErrorBoundary(1024);
        val.setWarningBoundary(2048);
        X509Certificate cert = this.getCertificate("1024.pem");
        Assert.assertEquals((Object)val.validate(cert, (Item)item, "stage"), (Object)Validator.Action.CONTINUE);
        this.errorsAndWarnings((Item<?>)item, 0, 1);
    }
}

