/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.validate.x509;

import java.security.cert.X509Certificate;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.MockItem;
import net.shibboleth.metadata.validate.Validator;
import net.shibboleth.metadata.validate.x509.BaseX509ValidatorTest;
import net.shibboleth.metadata.validate.x509.X509RSAOpenSSLBlacklistValidator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class X509RSAOpenSSLBlacklistValidatorTest
extends BaseX509ValidatorTest {
    public X509RSAOpenSSLBlacklistValidatorTest() throws Exception {
        super(X509RSAOpenSSLBlacklistValidator.class);
    }

    @Test
    public void testNotBlacklisted() throws Exception {
        X509RSAOpenSSLBlacklistValidator val = new X509RSAOpenSSLBlacklistValidator();
        val.setBlacklistResource(this.getClasspathResource("1024.txt"));
        val.initialize();
        Assert.assertEquals((int)val.getKeySize(), (int)0);
        MockItem item = new MockItem("foo");
        X509Certificate cert = this.getCertificate("ok.pem");
        Assert.assertEquals((Object)val.validate(cert, (Item)item, "stage"), (Object)Validator.Action.CONTINUE);
        this.errorsAndWarnings((Item<?>)item, 0, 0);
    }

    @Test
    public void test1024on1024noRestriction() throws Exception {
        X509RSAOpenSSLBlacklistValidator val = new X509RSAOpenSSLBlacklistValidator();
        val.setBlacklistResource(this.getClasspathResource("1024.txt"));
        val.initialize();
        Assert.assertEquals((int)val.getKeySize(), (int)0);
        MockItem item = new MockItem("foo");
        X509Certificate cert = this.getCertificate("1024.pem");
        Assert.assertEquals((Object)val.validate(cert, (Item)item, "stage"), (Object)Validator.Action.CONTINUE);
        this.errorsAndWarnings((Item<?>)item, 1, 0);
    }

    @Test
    public void test1024on1024Restricted() throws Exception {
        X509RSAOpenSSLBlacklistValidator val = new X509RSAOpenSSLBlacklistValidator();
        val.setBlacklistResource(this.getClasspathResource("1024.txt"));
        val.setKeySize(1024);
        val.initialize();
        MockItem item = new MockItem("foo");
        X509Certificate cert = this.getCertificate("1024.pem");
        Assert.assertEquals((Object)val.validate(cert, (Item)item, "stage"), (Object)Validator.Action.CONTINUE);
        this.errorsAndWarnings((Item<?>)item, 1, 0);
    }

    @Test
    public void test1024on1024Restricted2() throws Exception {
        X509RSAOpenSSLBlacklistValidator val = new X509RSAOpenSSLBlacklistValidator();
        val.setBlacklistResource(this.getClasspathResource("1024.txt"));
        val.setKeySize(2048);
        val.initialize();
        MockItem item = new MockItem("foo");
        X509Certificate cert = this.getCertificate("1024.pem");
        Assert.assertEquals((Object)val.validate(cert, (Item)item, "stage"), (Object)Validator.Action.CONTINUE);
        this.errorsAndWarnings((Item<?>)item, 0, 0);
    }

    @Test
    public void test2048on1024noRestriction() throws Exception {
        X509RSAOpenSSLBlacklistValidator val = new X509RSAOpenSSLBlacklistValidator();
        val.setBlacklistResource(this.getClasspathResource("1024.txt"));
        val.initialize();
        Assert.assertEquals((int)val.getKeySize(), (int)0);
        MockItem item = new MockItem("foo");
        X509Certificate cert = this.getCertificate("2048.pem");
        val.validate(cert, (Item)item, "stage");
        Assert.assertEquals((Object)val.validate(cert, (Item)item, "stage"), (Object)Validator.Action.CONTINUE);
    }

    @Test
    public void test2048on2048noRestriction() throws Exception {
        X509RSAOpenSSLBlacklistValidator val = new X509RSAOpenSSLBlacklistValidator();
        val.setBlacklistResource(this.getClasspathResource("2048.txt"));
        val.initialize();
        Assert.assertEquals((int)val.getKeySize(), (int)0);
        MockItem item = new MockItem("foo");
        X509Certificate cert = this.getCertificate("2048.pem");
        val.validate(cert, (Item)item, "stage");
        Assert.assertEquals((Object)val.validate(cert, (Item)item, "stage"), (Object)Validator.Action.CONTINUE);
    }

    @Test
    public void test2048on2048Restricted() throws Exception {
        X509RSAOpenSSLBlacklistValidator val = new X509RSAOpenSSLBlacklistValidator();
        val.setBlacklistResource(this.getClasspathResource("2048.txt"));
        val.setKeySize(2048);
        val.initialize();
        MockItem item = new MockItem("foo");
        X509Certificate cert = this.getCertificate("2048.pem");
        val.validate(cert, (Item)item, "stage");
        Assert.assertEquals((Object)val.validate(cert, (Item)item, "stage"), (Object)Validator.Action.CONTINUE);
    }

    @Test
    public void test2048on2048Restricted2() throws Exception {
        X509RSAOpenSSLBlacklistValidator val = new X509RSAOpenSSLBlacklistValidator();
        val.setBlacklistResource(this.getClasspathResource("2048.txt"));
        val.setKeySize(1024);
        val.initialize();
        MockItem item = new MockItem("foo");
        X509Certificate cert = this.getCertificate("2048.pem");
        Assert.assertEquals((Object)val.validate(cert, (Item)item, "stage"), (Object)Validator.Action.CONTINUE);
        this.errorsAndWarnings((Item<?>)item, 0, 0);
    }

    @Test
    public void testBlankLineIssue9() throws Exception {
        X509RSAOpenSSLBlacklistValidator val = new X509RSAOpenSSLBlacklistValidator();
        val.setBlacklistResource(this.getClasspathResource("issue9.txt"));
        val.initialize();
    }

    @Test
    public void classPathResource() throws Exception {
        X509RSAOpenSSLBlacklistValidator val = new X509RSAOpenSSLBlacklistValidator();
        val.setBlacklistResource((Resource)new ClassPathResource("net/shibboleth/metadata/validate/x509/debian-2048.txt"));
        val.setKeySize(2048);
        val.initialize();
        MockItem item = new MockItem("foo");
        X509Certificate cert = this.getCertificate("2048.pem");
        Assert.assertEquals((Object)val.validate(cert, (Item)item, "stage"), (Object)Validator.Action.CONTINUE);
        this.errorsAndWarnings((Item<?>)item, 1, 0);
    }
}

