/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemIdentificationStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

@ThreadSafe
public abstract class AbstractCompositeItemIdentificationStrategy
implements ItemIdentificationStrategy {
    private String noItemIdIdentifier = "unidentified";

    public String getNoItemIdIdentifier() {
        return this.noItemIdIdentifier;
    }

    public void setNoItemIdIdentifier(@Nonnull @NotEmpty String identifier) {
        this.noItemIdIdentifier = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)identifier), (String)"Identifier can not be null or empty");
    }

    @Nullable
    abstract String getBasicIdentifier(@Nonnull Item<?> var1);

    @Nullable
    abstract String getExtraIdentifier(@Nonnull Item<?> var1);

    @Override
    @Nonnull
    public String getItemIdentifier(@Nonnull Item<?> item) {
        Constraint.isNotNull(item, (String)"Item can not equal null");
        StringBuilder res = new StringBuilder();
        String basic = this.getBasicIdentifier(item);
        if (basic == null) {
            res.append(this.getNoItemIdIdentifier());
        } else {
            res.append(basic);
        }
        String extra = this.getExtraIdentifier(item);
        if (extra != null) {
            res.append(" (");
            res.append(extra);
            res.append(")");
        }
        return res.toString();
    }
}

