/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.metadata.CollectionMergeStrategy;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemId;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class DeduplicatingItemIdMergeStrategy
implements CollectionMergeStrategy {
    @Override
    public <T> void mergeCollection(@Nonnull @NonnullElements Collection<Item<T>> target, @Nonnull @NonnullElements List<Collection<Item<T>>> sources) {
        Constraint.isNotNull(target, (String)"Target collection can not be null");
        Constraint.isNotNull(sources, (String)"Source collections can not be null or empty");
        HashSet<ItemId> presentItemIds = new HashSet<ItemId>();
        for (Item<T> item : target) {
            List itemIds = item.getItemMetadata().get(ItemId.class);
            if (itemIds == null) continue;
            presentItemIds.addAll(itemIds);
        }
        for (Collection collection : sources) {
            this.merge(presentItemIds, target, collection);
        }
    }

    private <T> void merge(@Nonnull @NonnullElements HashSet<ItemId> presentItemIds, @Nonnull @NonnullElements Collection<Item<T>> target, @Nonnull @NonnullElements Collection<Item<T>> sourceItems) {
        for (Item<T> sourceItem : sourceItems) {
            List itemIds = sourceItem.getItemMetadata().get(ItemId.class);
            if (itemIds == null || itemIds.isEmpty()) {
                target.add(sourceItem);
                continue;
            }
            boolean itemAlreadyPresent = false;
            for (ItemId itemId : itemIds) {
                if (!presentItemIds.contains(itemId)) continue;
                itemAlreadyPresent = true;
                break;
            }
            if (itemAlreadyPresent) continue;
            target.add(sourceItem);
            presentItemIds.addAll(itemIds);
        }
    }
}

