/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.dom.saml.SAMLMetadataSupport;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.collection.ClassToInstanceMultiMap;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public abstract class AbstractDOMTraversalStage
extends BaseStage<Element> {
    protected abstract boolean applicable(@Nonnull Element var1);

    protected abstract void visit(@Nonnull Element var1, @Nonnull TraversalContext var2) throws StageProcessingException;

    private void traverse(@Nonnull Element element, @Nonnull TraversalContext context) throws StageProcessingException {
        List children = ElementSupport.getChildElements((Node)element);
        for (Element child : children) {
            this.traverse(child, context);
        }
        if (this.applicable(element)) {
            this.visit(element, context);
        }
    }

    @Override
    protected void doExecute(Collection<Item<Element>> itemCollection) throws StageProcessingException {
        for (Item<Element> item : itemCollection) {
            Element docElement = item.unwrap();
            TraversalContext context = new TraversalContext(item);
            this.traverse(docElement, context);
        }
    }

    protected Element ancestorEntity(@Nonnull Element element) {
        assert (element != null);
        for (Element e = element; e != null; e = (Element)e.getParentNode()) {
            if (!SAMLMetadataSupport.isEntityDescriptor(e)) continue;
            return e;
        }
        return null;
    }

    protected void addError(@Nonnull Item<Element> item, @Nonnull Element element, @Nonnull String error) {
        assert (item != null);
        assert (element != null);
        assert (error != null);
        ClassToInstanceMultiMap<ItemMetadata> metadata = item.getItemMetadata();
        String prefix = "";
        if (SAMLMetadataSupport.isEntitiesDescriptor(element)) {
            Element entity = this.ancestorEntity(element);
            Attr id = entity.getAttributeNode("ID");
            if (id != null) {
                prefix = id.getTextContent() + ": ";
            } else {
                Attr entityID = entity.getAttributeNode("entityID");
                if (entityID != null) {
                    prefix = entityID.getTextContent() + ": ";
                }
            }
        }
        metadata.put((Object)new ErrorStatus(this.getId(), prefix + error));
    }

    protected class TraversalContext {
        private final Item<Element> item;
        private final ClassToInstanceMultiMap<Object> stash = new ClassToInstanceMultiMap();

        public TraversalContext(Item<Element> contextItem) {
            this.item = contextItem;
        }

        public Item<Element> getItem() {
            return this.item;
        }

        public ClassToInstanceMultiMap<Object> getStash() {
            return this.stash;
        }
    }
}

