/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.metadata.dom.AbstractDOMTraversalStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.metadata.validate.Validator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;

public abstract class AbstractDOMValidationStage<V>
extends AbstractDOMTraversalStage {
    @Nonnull
    private List<Validator<V>> validators = Collections.emptyList();

    public void setValidators(@Nonnull List<Validator<V>> newValidators) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.validators = ImmutableList.copyOf((Iterable)Iterables.filter(newValidators, (Predicate)Predicates.notNull()));
    }

    @Nonnull
    public List<Validator<V>> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    protected void applyValidators(@Nonnull V obj, @Nonnull AbstractDOMTraversalStage.TraversalContext context) throws StageProcessingException {
        for (Validator<V> validator : this.validators) {
            Validator.Action action = validator.validate(obj, context.getItem(), this.getId());
            if (action != Validator.Action.DONE) continue;
            return;
        }
    }

    protected void doDestroy() {
        this.validators = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        for (Validator<V> validator : this.validators) {
            if (validator.isInitialized()) continue;
            validator.initialize();
        }
    }
}

