/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.metadata.dom.AbstractDOMTraversalStage;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.w3c.dom.Element;

public abstract class AbstractElementVisitingStage
extends AbstractDOMTraversalStage {
    @Nonnull
    private Set<QName> elementNames = Collections.emptySet();

    protected void doDestroy() {
        this.elementNames = null;
        super.doDestroy();
    }

    @Nonnull
    public Collection<QName> getElementNames() {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        return this.elementNames;
    }

    public void setElementNames(@Nonnull Collection<QName> names) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(names, (String)"elementNames may not be null");
        this.elementNames = new HashSet<QName>(names);
    }

    public void setElementName(@Nonnull QName name) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)name, (String)"elementName may not be null");
        this.elementNames = Collections.singleton(name);
    }

    @Override
    protected boolean applicable(@Nonnull Element e) {
        QName q = new QName(e.getNamespaceURI(), e.getLocalName());
        return this.elementNames.contains(q);
    }
}

