/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.ItemMetadata;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.collection.ClassToInstanceMultiMap;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ThreadSafe
public abstract class AbstractNamespacesStrippingStage
extends BaseStage<Element> {
    private final Logger log = LoggerFactory.getLogger(AbstractNamespacesStrippingStage.class);

    protected abstract boolean removingNamespace(String var1);

    private void processItem(@Nonnull Item<Element> item) {
        Element element = (Element)((Item)Constraint.isNotNull(item, (String)"Item can not be null")).unwrap();
        if (this.removingNamespace(element.getNamespaceURI())) {
            ClassToInstanceMultiMap<ItemMetadata> metadata = item.getItemMetadata();
            metadata.put((Object)new ErrorStatus(this.getId(), "can't strip namespace from document element"));
            return;
        }
        this.processElement(element, 0);
    }

    private void processAttributes(@Nonnull Element element) {
        Constraint.isNotNull((Object)element, (String)"Element can not be null");
        NamedNodeMap attributes = element.getAttributes();
        ArrayList<Attr> removeTarget = new ArrayList<Attr>();
        ArrayList<Attr> removePrefix = new ArrayList<Attr>();
        for (int aIndex = 0; aIndex < attributes.getLength(); ++aIndex) {
            Attr attribute = (Attr)attributes.item(aIndex);
            String attrNamespace = attribute.getNamespaceURI();
            String attrLocalName = attribute.getLocalName();
            this.log.trace("checking attribute {{}}:{}", (Object)attrNamespace, (Object)attrLocalName);
            if ("http://www.w3.org/2000/xmlns/".equals(attrNamespace)) {
                if (!this.removingNamespace(attribute.getTextContent())) continue;
                this.log.trace("   prefix {} definition; will remove", (Object)attrLocalName);
                removeTarget.add(attribute);
                continue;
            }
            if (attrNamespace == null || !this.removingNamespace(attrNamespace)) continue;
            this.log.trace("   in target namespace; will remove");
            removePrefix.add(attribute);
        }
        for (Attr a : removeTarget) {
            element.removeAttributeNode(a);
        }
        for (Attr a : removePrefix) {
            element.removeAttributeNode(a);
        }
    }

    private void processElement(@Nonnull Element element, int depth) {
        Constraint.isNotNull((Object)element, (String)"Element can not be null");
        this.log.trace("{}: element {}", (Object)depth, (Object)element.getLocalName());
        if (this.removingNamespace(element.getNamespaceURI())) {
            this.log.trace("{}: removing element entirely", (Object)depth);
            element.getParentNode().removeChild(element);
            return;
        }
        NodeList children = element.getChildNodes();
        for (int eIndex = 0; eIndex < children.getLength(); ++eIndex) {
            Node child = children.item(eIndex);
            if (!(child instanceof Element)) continue;
            this.processElement((Element)child, depth + 1);
        }
        this.processAttributes(element);
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<Item<Element>> items) throws StageProcessingException {
        for (Item<Element> item : items) {
            this.processItem(item);
        }
    }
}

