/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.shibboleth.metadata.ErrorStatus;
import net.shibboleth.metadata.InfoStatus;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.WarningStatus;
import net.shibboleth.metadata.pipeline.BaseStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.w3c.dom.Element;

@ThreadSafe
public abstract class AbstractXSLProcessingStage
extends BaseStage<Element> {
    private final Logger log = LoggerFactory.getLogger(AbstractXSLProcessingStage.class);
    private Resource xslResource;
    private Templates xslTemplate;
    private Map<String, Object> transformAttributes = Collections.emptyMap();
    private Map<String, Boolean> transformFeatures = Collections.emptyMap();
    private Map<String, Object> transformParameters = Collections.emptyMap();
    @Nullable
    private URIResolver uriResolver;

    @Nullable
    public Resource getXSLResource() {
        return this.xslResource;
    }

    public synchronized void setXSLResource(@Nonnull Resource resource) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.xslResource = (Resource)Constraint.isNotNull((Object)resource, (String)"XSL resource can not be null");
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, Object> getTransformAttributes() {
        return this.transformAttributes;
    }

    public synchronized void setTransformAttributes(@Nullable @NullableElements Map<String, Object> attributes) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (attributes == null || attributes.isEmpty()) {
            this.transformAttributes = Collections.emptyMap();
        }
        HashMap<String, Object> newAttributes = new HashMap<String, Object>();
        for (String attributeName : attributes.keySet()) {
            if (attributeName == null) continue;
            newAttributes.put(attributeName, attributes.get(attributeName));
        }
        this.transformAttributes = Collections.unmodifiableMap(newAttributes);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, Boolean> getTransformFeatures() {
        return this.transformFeatures;
    }

    public synchronized void setTransformFeatures(@Nullable @NullableElements Map<String, Boolean> features) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (features == null || features.isEmpty()) {
            this.transformFeatures = Collections.emptyMap();
        }
        HashMap<String, Boolean> newFeatures = new HashMap<String, Boolean>();
        for (String featuresName : features.keySet()) {
            if (featuresName == null) continue;
            newFeatures.put(featuresName, features.get(featuresName));
        }
        this.transformFeatures = Collections.unmodifiableMap(newFeatures);
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, Object> getTransformParameters() {
        return this.transformParameters;
    }

    public synchronized void setTransformParameters(@Nullable @NullableElements Map<String, Object> parameters) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (parameters == null) {
            this.transformParameters = Collections.emptyMap();
            return;
        }
        HashMap<String, Object> newParams = new HashMap<String, Object>();
        for (String paramName : parameters.keySet()) {
            if (paramName == null) continue;
            newParams.put(paramName, parameters.get(paramName));
        }
        this.transformParameters = Collections.unmodifiableMap(newParams);
    }

    @Nullable
    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public synchronized void setURIResolver(@Nullable URIResolver resolver) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.uriResolver = resolver;
    }

    @Override
    protected void doExecute(@Nonnull @NonnullElements Collection<Item<Element>> itemCollection) throws StageProcessingException {
        try {
            Transformer transformer = this.xslTemplate.newTransformer();
            for (Map.Entry<String, Object> entry : this.transformParameters.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
            this.executeTransformer(transformer, itemCollection);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("XSL transformation engine misconfigured", e);
        }
    }

    protected abstract void executeTransformer(@Nonnull Transformer var1, @Nonnull @NonnullElements Collection<Item<Element>> var2) throws StageProcessingException, TransformerConfigurationException;

    protected void doDestroy() {
        this.xslResource = null;
        this.xslTemplate = null;
        this.transformAttributes = null;
        this.transformFeatures = null;
        this.transformParameters = null;
        this.uriResolver = null;
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.xslResource == null) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", XslResource must not be null");
        }
        try {
            if (!this.xslResource.exists()) {
                throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", XslResource " + this.xslResource.getDescription() + " does not exist");
            }
            TransformerFactory tfactory = TransformerFactory.newInstance();
            for (Map.Entry<String, Object> entry : this.transformAttributes.entrySet()) {
                tfactory.setAttribute(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.transformFeatures.entrySet()) {
                tfactory.setFeature(entry.getKey(), (Boolean)entry.getValue());
            }
            if (this.uriResolver != null) {
                tfactory.setURIResolver(this.uriResolver);
            }
            this.log.debug("{} pipeline stage compiling XSL file {}", (Object)this.getId(), (Object)this.xslResource);
            this.xslTemplate = tfactory.newTemplates(new StreamSource(this.xslResource.getInputStream(), this.xslResource.getURL().toExternalForm()));
        }
        catch (TransformerConfigurationException e) {
            throw new ComponentInitializationException("XSL transformation engine misconfigured", (Exception)e);
        }
        catch (IOException e) {
            throw new ComponentInitializationException("Unable to initialize " + this.getId() + ", error reading XslResource " + this.xslResource.getDescription() + " information", (Exception)e);
        }
    }

    public class StatusInfoAppendingErrorListener
    implements ErrorListener {
        public static final String ERROR_PREFIX = "[ERROR]";
        public static final String WARN_PREFIX = "[WARN]";
        public static final String INFO_PREFIX = "[INFO]";
        private Item<?> item;

        public StatusInfoAppendingErrorListener(Item<?> receivingItem) {
            this.item = receivingItem;
        }

        @Override
        public void error(@Nonnull TransformerException e) throws TransformerException {
            this.parseAndAppendStatusInfo(e);
        }

        @Override
        public void fatalError(@Nonnull TransformerException e) throws TransformerException {
            this.parseAndAppendStatusInfo(e);
        }

        @Override
        public void warning(@Nonnull TransformerException e) throws TransformerException {
            this.parseAndAppendStatusInfo(e);
        }

        private void parseAndAppendStatusInfo(@Nonnull TransformerException e) throws TransformerException {
            String errorMessage = StringSupport.trimOrNull((String)e.getMessage());
            if (errorMessage == null) {
                throw e;
            }
            if (errorMessage.startsWith(ERROR_PREFIX)) {
                String statusMessage = StringSupport.trim((String)errorMessage.substring(ERROR_PREFIX.length()));
                this.item.getItemMetadata().put((Object)new ErrorStatus(AbstractXSLProcessingStage.this.getId(), statusMessage));
            } else if (errorMessage.startsWith(WARN_PREFIX)) {
                String statusMessage = StringSupport.trim((String)errorMessage.substring(WARN_PREFIX.length()));
                this.item.getItemMetadata().put((Object)new WarningStatus(AbstractXSLProcessingStage.this.getId(), statusMessage));
            } else if (errorMessage.startsWith(INFO_PREFIX)) {
                String statusMessage = StringSupport.trim((String)errorMessage.substring(INFO_PREFIX.length()));
                this.item.getItemMetadata().put((Object)new InfoStatus(AbstractXSLProcessingStage.this.getId(), statusMessage));
            } else {
                throw e;
            }
        }
    }
}

