/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.dom.AbstractDOMTraversalStage;
import net.shibboleth.metadata.pipeline.StageProcessingException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CRDetectionStage
extends AbstractDOMTraversalStage {
    private static final char CR = '\r';

    @Override
    protected boolean applicable(Element element) {
        return true;
    }

    @Override
    protected void visit(Element element, AbstractDOMTraversalStage.TraversalContext context) throws StageProcessingException {
        if (!context.getStash().isEmpty()) {
            return;
        }
        Item<Element> item = context.getItem();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3 || node.getNodeValue().indexOf(13) < 0) continue;
            this.addError(item, element, "element text content contains a carriage return character");
            context.getStash().put((Object)Boolean.TRUE);
            return;
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            Node attribute = attributes.item(index);
            if (attribute.getNodeValue().indexOf(13) < 0) continue;
            this.addError(item, element, "attribute value contains a carriage return character");
            context.getStash().put((Object)Boolean.TRUE);
            return;
        }
    }
}

