/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.metadata.dom;

import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.metadata.AbstractItem;
import net.shibboleth.metadata.Item;
import net.shibboleth.metadata.util.ItemMetadataSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ThreadSafe
public class DOMElementItem
extends AbstractItem<Element> {
    private static final long serialVersionUID = -5122481126094725529L;

    public DOMElementItem(@Nonnull Document document) {
        Constraint.isNotNull((Object)document, (String)"DOM Document can not be null");
        Element docElement = document.getDocumentElement();
        Constraint.isNotNull((Object)docElement, (String)"DOM Document Element may not be null");
        this.setData(document.getDocumentElement());
    }

    public DOMElementItem(@Nonnull Element element) {
        Constraint.isNotNull((Object)element, (String)"DOM Document Element may not be null");
        DOMImplementation domImpl = element.getOwnerDocument().getImplementation();
        Document newDocument = domImpl.createDocument(null, null, null);
        Element newDocumentRoot = (Element)newDocument.importNode(element, true);
        ElementSupport.setDocumentElement((Document)newDocument, (Element)newDocumentRoot);
        this.setData(newDocumentRoot);
    }

    @Override
    public Item<Element> copy() {
        DOMElementItem clone = new DOMElementItem((Element)this.unwrap());
        ItemMetadataSupport.addAll(clone, this.getItemMetadata().values());
        return clone;
    }
}

